/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui.refactoring;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

@NonNullByDefault
public class TextEditAnnotator
extends TextEditVisitor {
    private int writtenToOffset = 0;
    private int chunks;
    private final StringBuilder sb;
    private final IDocument previewDocument;

    public TextEditAnnotator(StringBuilder sb, IDocument previewDoc) {
        this.sb = sb;
        this.previewDocument = previewDoc;
    }

    public void unchangedUntil(int offset) {
        if (offset > this.writtenToOffset) {
            this.appendContent(this.previewDocument, this.writtenToOffset, offset, true);
            this.writtenToOffset = offset;
        }
    }

    public boolean visit(MoveTargetEdit edit) {
        return true;
    }

    public boolean visit(CopyTargetEdit edit) {
        return true;
    }

    public boolean visit(InsertEdit edit) {
        return this.rangeAdded((TextEdit)edit);
    }

    public boolean visit(ReplaceEdit edit) {
        if (edit.getLength() > 0) {
            return this.rangeAdded((TextEdit)edit);
        }
        return this.rangeRemoved((TextEdit)edit);
    }

    public boolean visit(MoveSourceEdit edit) {
        return this.rangeRemoved((TextEdit)edit);
    }

    public boolean visit(DeleteEdit edit) {
        return this.rangeRemoved((TextEdit)edit);
    }

    public boolean visit(RangeMarker edit) {
        this.unchangedUntil(edit.getOffset());
        return true;
    }

    protected boolean rangeRemoved(TextEdit edit) {
        this.unchangedUntil(edit.getOffset());
        return false;
    }

    protected boolean rangeAdded(TextEdit edit) {
        return this.annotateEdit(edit, "<b>", "</b>");
    }

    protected boolean annotateEdit(TextEdit edit, String startTag, String endTag) {
        this.unchangedUntil(edit.getOffset());
        this.sb.append(startTag);
        this.appendContent(this.previewDocument, edit.getOffset(), edit.getExclusiveEnd(), false);
        this.sb.append(endTag);
        this.writtenToOffset = edit.getExclusiveEnd();
        return false;
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, boolean surroundLinesOnly) {
        boolean surroundLines = true;
        try {
            boolean firstChunk = this.chunks++ == 0;
            int startLine = text.getLineOfOffset(surroundLinesOnly && firstChunk ? endOffset : startOffset);
            int endLine = text.getLineOfOffset(endOffset);
            boolean dotsAdded = false;
            if (surroundLinesOnly && startOffset == 0) {
                startLine = endLine;
                dotsAdded = true;
            }
            int i = startLine;
            while (i <= endLine) {
                if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                    if (!dotsAdded) {
                        this.sb.append("...<br/>");
                        dotsAdded = true;
                    } else if (endOffset == text.getLength()) {
                        return;
                    }
                } else {
                    IRegion lineInfo = text.getLineInformation(i);
                    int start = lineInfo.getOffset();
                    int end = start + lineInfo.getLength();
                    int from = Math.max(start, startOffset);
                    int to = Math.min(end, endOffset);
                    String content = text.get(from, to - from);
                    if (!surroundLinesOnly || from != start || !content.isEmpty()) {
                        int k = 0;
                        while (k < content.length()) {
                            char ch = content.charAt(k);
                            switch (ch) {
                                case '<': {
                                    this.sb.append("&lt;");
                                    break;
                                }
                                case '>': {
                                    this.sb.append("&gt;");
                                    break;
                                }
                                default: {
                                    this.sb.append(ch);
                                }
                            }
                            ++k;
                        }
                        if (to == end && to != endOffset) {
                            this.sb.append("<br/>");
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

