/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.project.core.builder;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.project.core.LtkProject;
import org.eclipse.statet.ltk.project.core.builder.ProjectBuildParticipant;
import org.eclipse.statet.ltk.project.core.builder.ProjectBuildTask;
import org.eclipse.statet.ltk.project.core.builder.ProjectCleanTask;

@NonNullByDefault
public abstract class ProjectTaskBuilder<TProject extends LtkProject, TSourceUnit extends WorkspaceSourceUnit, TParticipant extends ProjectBuildParticipant<TProject, TSourceUnit>>
extends IncrementalProjectBuilder {
    private TProject ltkProject = (LtkProject)ObjectUtils.nonNullLateInit();

    public abstract BuilderDefinition<TProject, TSourceUnit, TParticipant> getBuilderDefinition();

    public abstract ImList<IssueTypeSet> getIssueTypeSets();

    public TProject getLtkProject() {
        return this.ltkProject;
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        try {
            this.ltkProject = (LtkProject)this.getProject().getNature(this.getBuilderDefinition().getProjectNatureId());
        }
        catch (CoreException e) {
            this.log(e.getStatus());
        }
    }

    private void check(SubMonitor progress) throws CoreException {
        if (this.ltkProject == null) {
            throw new CoreException((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), NLS.bind((String)"{0} project nature is missing.", (Object)this.getBuilderDefinition().getProjectTypeLabel())));
        }
    }

    protected IProject @Nullable [] build(int kind, @Nullable Map<String, @Nullable String> args, @Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)21);
        try {
            this.check(m.newChild(1, 0));
            ProjectBuildTask<TProject, TSourceUnit, TParticipant> projectTask = this.createBuildTask();
            projectTask.build(kind, m.newChild(20, 0));
            return null;
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            throw e;
        }
        finally {
            m.done();
        }
    }

    protected void clean(@Nullable IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)21);
        try {
            try {
                this.check(m.newChild(1, 0));
                ProjectCleanTask<TProject, TSourceUnit, TParticipant> projectTask = this.createCleanTask();
                projectTask.clean(m.newChild(20, 0));
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() == 8) {
                    throw new OperationCanceledException();
                }
                throw e;
            }
        }
        finally {
            m.done();
        }
    }

    protected abstract ProjectBuildTask<TProject, TSourceUnit, TParticipant> createBuildTask();

    protected abstract ProjectCleanTask<TProject, TSourceUnit, TParticipant> createCleanTask();

    protected void log(IStatus status) {
        ILog log = this.getBuilderDefinition().getBundle().getLog();
        if (log != null) {
            log.log(status);
        }
    }

    public static abstract class BuilderDefinition<TProject extends LtkProject, TSourceUnit extends WorkspaceSourceUnit, TBuildParticipant extends ProjectBuildParticipant<TProject, TSourceUnit>> {
        private final String bundleId;
        private final Plugin bundle;
        private final String projectNatureId;
        private final String projectTypeLabel;
        private final Class<TSourceUnit> sourceUnitType;
        private final Class<TBuildParticipant> participantType;

        public BuilderDefinition(String bundleId, Plugin bundle, String projectNatureId, String projectLabel, Class<TSourceUnit> sourceUnitType, Class<TBuildParticipant> participantType) {
            this.bundleId = bundleId;
            this.bundle = bundle;
            this.projectNatureId = projectNatureId;
            this.projectTypeLabel = projectLabel;
            this.sourceUnitType = sourceUnitType;
            this.participantType = participantType;
        }

        public String getBundleId() {
            return this.bundleId;
        }

        public Plugin getBundle() {
            return this.bundle;
        }

        public String getProjectNatureId() {
            return this.projectNatureId;
        }

        public String getProjectTypeLabel() {
            return this.projectTypeLabel;
        }

        public abstract int checkSourceUnitContent(IContentType var1);

        public Class<TSourceUnit> getSourceUnitType() {
            return this.sourceUnitType;
        }

        public Class<TBuildParticipant> getParticipantType() {
            return this.participantType;
        }
    }
}

