/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.cell;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.layer.cell.AbstractOverrider;

public class ColumnOverrideLabelAccumulator
extends AbstractOverrider
implements Persistable {
    public static final String PERSISTENCE_KEY = ".columnOverrideLabelAccumulator";
    private final Layer layer;

    public ColumnOverrideLabelAccumulator(Layer layer) {
        this.layer = layer;
    }

    @Override
    public void addLabels(LabelStack configLabels, long columnPosition, long rowPosition) {
        long columnIndex = this.layer.getDim(Orientation.HORIZONTAL).getPositionId(columnPosition, columnPosition);
        List<String> overrides = this.getOverrides(Long.valueOf(columnIndex));
        if (overrides != null) {
            for (String configLabel : overrides) {
                configLabels.addLabel(configLabel);
            }
        }
    }

    public void registerColumnOverrides(long columnIndex, String ... configLabels) {
        super.registerOverrides((Serializable)Long.valueOf(columnIndex), configLabels);
    }

    public void registerColumnOverridesOnTop(long columnIndex, String ... configLabels) {
        super.registerOverridesOnTop(Long.valueOf(columnIndex), configLabels);
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        Map<Serializable, List<String>> overrides = this.getOverrides();
        for (Map.Entry<Serializable, List<String>> entry : overrides.entrySet()) {
            StringBuilder strBuilder = new StringBuilder();
            for (String columnLabel : entry.getValue()) {
                strBuilder.append(columnLabel);
                strBuilder.append(",");
            }
            String propertyValue = strBuilder.toString();
            if (propertyValue.endsWith(",")) {
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
            }
            String propertyKey = String.valueOf(prefix) + PERSISTENCE_KEY + "." + entry.getKey();
            properties.put(propertyKey, propertyValue);
        }
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.contains(PERSISTENCE_KEY)) continue;
            String labelsFromPropertyValue = entry.getValue().trim();
            String columnIndexFromKey = key.substring(key.lastIndexOf(".") + 1);
            this.registerColumnOverrides(Long.parseLong(columnIndexFromKey), labelsFromPropertyValue.split(","));
        }
    }
}

