/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.css.dom;

import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.utils.ClassUtils;
import org.eclipse.statet.ecommons.ui.workbench.css.dom.VirtualCompositeStylableElement;
import org.eclipse.statet.internal.ecommons.ui.swt.css.dom.VirtualWidget;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.w3c.dom.NodeList;

@NonNullByDefault
public abstract class VirtualStylableElement<TParent extends CSSStylableElement>
extends ElementAdapter
implements NodeList {
    private final TParent parent;
    private final String name;
    private final @Nullable String cssClass;
    private ImList<? extends VirtualStylableElement<? extends VirtualStylableElement<?>>> children = ImCollections.emptyList();

    public VirtualStylableElement(TParent parent, String name, @Nullable String cssClass, CSSEngine engine) {
        super((Object)new VirtualWidget(), engine);
        ((VirtualWidget)this.getNativeWidget()).setElement((CSSStylableElement)this);
        this.parent = parent;
        this.name = name;
        this.cssClass = cssClass;
    }

    protected void init(ImList<? extends VirtualStylableElement<? extends VirtualStylableElement<TParent>>> children) {
        this.children = children;
    }

    public void dispose() {
        super.dispose();
        for (VirtualStylableElement child : this.children) {
            child.dispose();
        }
    }

    public TParent getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public int getLength() {
        return this.children.size();
    }

    public @Nullable VirtualStylableElement<? extends VirtualStylableElement<?>> item(int index) {
        if (index >= 0 && index < this.children.size()) {
            return (VirtualStylableElement)this.children.get(index);
        }
        return null;
    }

    public @Nullable String getNamespaceURI() {
        return ClassUtils.getPackageName(VirtualCompositeStylableElement.class);
    }

    public String getLocalName() {
        return this.name;
    }

    public @Nullable String getCSSId() {
        return null;
    }

    public @Nullable String getCSSClass() {
        return this.cssClass;
    }

    public @Nullable String getCSSStyle() {
        return null;
    }

    public String getAttribute(String name) {
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        VirtualStylableElement.appendNameRec(sb, this);
        return sb.toString();
    }

    static void appendNameRec(StringBuilder sb, VirtualStylableElement<?> element) {
        Object parentNode = element.getParentNode();
        if (parentNode instanceof VirtualStylableElement) {
            VirtualStylableElement.appendNameRec(sb, (VirtualStylableElement)parentNode);
            sb.append(' ');
        } else {
            VirtualStylableElement.appendName(sb, parentNode, true);
            sb.append(' ');
        }
        VirtualStylableElement.appendName(sb, element, false);
    }

    static void appendName(StringBuilder sb, CSSStylableElement element, boolean id) {
        sb.append(element.getLocalName());
        String cssClass = element.getCSSClass();
        if (cssClass != null) {
            sb.append('.').append(cssClass);
        }
        if (id) {
            sb.append('#').append(System.identityHashCode(element));
        }
    }
}

