/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.ObservableFileValidator;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.CustomizableVariableSelectionDialog;
import org.eclipse.statet.ecommons.ui.components.WidgetToolsButton;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceContainerSelectionDialog;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceFileSelectionDialog;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ResourceInputComposite
extends Composite
implements IValueChangeListener<Object> {
    private static final String VAR_WORKSPACE_LOC = "workspace_loc";
    public static final int MODE_FILE = 1;
    public static final int MODE_DIRECTORY = 2;
    public static final int MODE_SAVE = 4;
    public static final int MODE_OPEN = 8;
    public static final int MODE_WS_ONLY = 16;
    public static final int STYLE_TEXT = 0;
    public static final int STYLE_COMBO = 1;
    public static final int STYLE_GROUP = 2;
    public static final int STYLE_LABEL = 4;
    private String resourceLabel;
    private final int style;
    private final boolean asCombo;
    private boolean forDirectory;
    private boolean forFile;
    private boolean doOpen;
    private boolean wsOnly;
    private boolean controlledChange;
    private final ObservableFileValidator validator = new ObservableFileValidator(Realm.getDefault());
    private Text locationTextField;
    private Combo locationComboField;
    private Label label;
    private WidgetToolsButton tools;
    private boolean showInsertVariable;
    private ImList<? extends StringVariableSelectionDialog.VariableFilter> showInsertVariableFilters;
    private ImList<? extends IStringVariable> showInsertVariableAdditionals;
    private String defaultFilesystemPath;
    private String[] fileFilters;
    private String[] fileFilterNames;

    public ResourceInputComposite(Composite parent, int style, int mode, String resourceLabel) {
        super(parent, 0);
        this.setMode(mode);
        this.style = style;
        this.asCombo = (this.style & 1) == 1;
        this.controlledChange = false;
        this.setResourceLabel(resourceLabel);
        this.createContent();
    }

    public void setHistory(String[] history) {
        if (history != null && this.asCombo) {
            this.locationComboField.setItems(history);
        }
    }

    public void setMode(int mode) {
        assert ((mode & 3) != 0);
        if ((mode & 2) == 2) {
            this.forDirectory = true;
            this.validator.setOnDirectory(0);
        } else {
            this.forDirectory = false;
            this.validator.setOnDirectory(4);
        }
        if ((mode & 1) == 1) {
            this.forFile = true;
            this.validator.setOnFile(0);
        } else {
            this.forFile = false;
            this.validator.setOnFile(4);
        }
        this.doOpen = (mode & 8) == 8;
        this.validator.setDefaultMode(this.doOpen);
        this.wsOnly = (mode & 0x10) == 16;
        this.validator.setRequireWorkspace(this.wsOnly, this.wsOnly);
        if (this.wsOnly) {
            this.validator.getWorkspaceResourceObservable().addValueChangeListener((IValueChangeListener)this);
        } else {
            this.validator.getFileStoreObservable().addValueChangeListener((IValueChangeListener)this);
        }
        if (this.tools != null) {
            this.tools.resetMenu();
        }
    }

    public void setResourceLabel(String label) {
        this.resourceLabel = label;
        if (this.label != null) {
            this.label.setText(String.valueOf(this.resourceLabel) + ':');
        }
        this.validator.setResourceLabel(MessageUtils.removeMnemonics(label));
    }

    protected String getTaskLabel() {
        return NLS.bind((String)Messages.ChooseResource_Task_description, (Object)this.resourceLabel);
    }

    public void setShowInsertVariable(boolean enable, List<StringVariableSelectionDialog.VariableFilter> filters, List<? extends IStringVariable> additionals) {
        Pattern pattern;
        String name;
        this.showInsertVariable = enable;
        ImList imList = this.showInsertVariableFilters = filters != null ? ImCollections.toList(filters) : null;
        if (this.showInsertVariableAdditionals != null) {
            for (IStringVariable variable : this.showInsertVariableAdditionals) {
                name = variable.getName();
                pattern = Pattern.compile("\\Q${" + name + "\\E[\\}\\:]");
                this.validator.setOnPattern(pattern, -1);
            }
        }
        ImList imList2 = this.showInsertVariableAdditionals = additionals != null ? ImCollections.toList(additionals) : null;
        if (this.showInsertVariableAdditionals != null) {
            for (IStringVariable variable : this.showInsertVariableAdditionals) {
                name = variable.getName();
                pattern = Pattern.compile("\\Q${" + name + "\\E[\\}\\:]");
                this.validator.setOnPattern(pattern, 0);
            }
        }
        if (this.tools != null) {
            this.tools.resetMenu();
        }
    }

    public void setDefaultFilesystemPath(String path) {
        this.defaultFilesystemPath = path != null && !path.isEmpty() ? path : null;
    }

    public void setFileFilters(List<String[]> filters) {
        String[] names;
        String[] extensions0;
        if (filters != null) {
            int n = filters.size() + 1;
            extensions0 = new String[n];
            names = new String[n];
            int i = 0;
            while (i < n - 1) {
                String[] strings = filters.get(i);
                extensions0[i] = strings[0];
                names[i] = String.valueOf(strings[1]) + " (" + strings[0] + ")";
                ++i;
            }
            extensions0[n - 1] = "*.*";
            names[n - 1] = String.valueOf(Messages.ChooseResource_AllFiles_name) + " (*.*)";
        } else {
            extensions0 = null;
            names = null;
        }
        this.fileFilters = extensions0;
        this.fileFilterNames = names;
    }

    public Control getTextControl() {
        if (this.asCombo) {
            return this.locationComboField;
        }
        return this.locationTextField;
    }

    protected String escapeText(String text) {
        if (this.validator.getVariableResolver() != null) {
            return this.validator.getVariableResolver().escapeText(text);
        }
        return text;
    }

    protected void setText(String text) {
        this.setText(text, true);
    }

    private void setText(String s, boolean validate) {
        if (!validate) {
            this.controlledChange = true;
        }
        if (this.asCombo) {
            this.locationComboField.setText(s);
        } else {
            this.locationTextField.setText(s);
        }
        if (!validate) {
            this.controlledChange = false;
        }
    }

    protected void insertText(String s) {
        if (!this.asCombo) {
            this.locationTextField.insert(s);
        }
    }

    protected String getText() {
        if (this.asCombo) {
            return this.locationComboField.getText();
        }
        return this.locationTextField.getText();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean editable = true;
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
        if (this.locationTextField != null) {
            this.locationTextField.setEnabled(enabled);
            editable = this.locationTextField.getEditable();
        }
        if (this.locationComboField != null) {
            this.locationComboField.setEnabled(enabled);
        }
        if (this.tools != null) {
            this.tools.setEnabled(enabled && editable);
        }
    }

    public void setEditable(boolean editable) {
        boolean enabled = true;
        this.locationTextField.setEditable(editable);
        enabled = this.locationTextField.isEnabled();
        if (this.tools != null) {
            this.tools.setEnabled(enabled && editable);
        }
    }

    private void createContent() {
        GridLayout layout;
        ResourceInputComposite content;
        if ((this.style & 2) == 2) {
            this.setLayout((Layout)new FillLayout());
            Group group = new Group((Composite)this, 0);
            group.setText(String.valueOf(this.resourceLabel) + ':');
            content = group;
            layout = LayoutUtils.newGroupGrid(2);
        } else {
            content = this;
            layout = LayoutUtils.newCompositeGrid(2);
        }
        layout.horizontalSpacing = 0;
        content.setLayout((Layout)layout);
        if ((this.style & 4) != 0) {
            this.label = new Label((Composite)content, 16384);
            this.label.setText(String.valueOf(this.resourceLabel) + ':');
            this.label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        }
        if (this.asCombo) {
            this.locationComboField = new Combo((Composite)content, 4);
        } else {
            this.locationTextField = new Text((Composite)content, 2052);
        }
        Control inputField = this.getTextControl();
        inputField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ResourceInputComposite.this.controlledChange) {
                    ResourceInputComposite.this.validator.setExplicit((Object)ResourceInputComposite.this.getText());
                }
            }
        });
        this.tools = new WidgetToolsButton(inputField){

            @Override
            protected void fillMenu(Menu menu) {
                ResourceInputComposite.this.fillMenu(menu);
            }
        };
        this.tools.setLayoutData(new GridData(16384, 128, false, false));
    }

    protected void fillMenu(Menu menu) {
        boolean both = this.forFile && this.forDirectory;
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.SearchWorkspace_label);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceInputComposite.this.beforeMenuAction();
                ResourceInputComposite.this.handleSearchWorkspaceButton();
                ResourceInputComposite.this.getTextControl().setFocus();
                ResourceInputComposite.this.afterMenuAction();
            }
        });
        if (this.forFile) {
            item = new MenuItem(menu, 8);
            item.setText(both ? Messages.BrowseWorkspace_ForFile_label : Messages.BrowseWorkspace_label);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceInputComposite.this.beforeMenuAction();
                    ResourceInputComposite.this.handleBrowseWorkspaceButton(1);
                    ResourceInputComposite.this.getTextControl().setFocus();
                    ResourceInputComposite.this.afterMenuAction();
                }
            });
        }
        if (this.forDirectory) {
            item = new MenuItem(menu, 8);
            item.setText(both ? Messages.BrowseWorkspace_ForDir_label : Messages.BrowseWorkspace_label);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceInputComposite.this.beforeMenuAction();
                    ResourceInputComposite.this.handleBrowseWorkspaceButton(2);
                    ResourceInputComposite.this.getTextControl().setFocus();
                    ResourceInputComposite.this.afterMenuAction();
                }
            });
        }
        if (this.forFile && !this.wsOnly) {
            item = new MenuItem(menu, 8);
            item.setText(both ? Messages.BrowseFilesystem_ForFile_label : Messages.BrowseFilesystem_label);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceInputComposite.this.beforeMenuAction();
                    ResourceInputComposite.this.handleBrowseFilesystemButton(1);
                    ResourceInputComposite.this.getTextControl().setFocus();
                    ResourceInputComposite.this.afterMenuAction();
                }
            });
        }
        if (this.forDirectory && !this.wsOnly) {
            item = new MenuItem(menu, 8);
            item.setText(both ? Messages.BrowseFilesystem_ForDir_label : Messages.BrowseFilesystem_label);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceInputComposite.this.beforeMenuAction();
                    ResourceInputComposite.this.handleBrowseFilesystemButton(2);
                    ResourceInputComposite.this.getTextControl().setFocus();
                    ResourceInputComposite.this.afterMenuAction();
                }
            });
        }
        if (this.showInsertVariable) {
            new MenuItem(menu, 2);
        }
        if (this.showInsertVariable) {
            item = new MenuItem(menu, 8);
            item.setText(SharedMessages.InsertVariable_label);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceInputComposite.this.beforeMenuAction();
                    ResourceInputComposite.this.handleVariablesButton();
                    ResourceInputComposite.this.getTextControl().setFocus();
                    ResourceInputComposite.this.afterMenuAction();
                }
            });
        }
    }

    protected void handleSearchWorkspaceButton() {
        String current;
        int idx;
        int resourceMode = 0;
        if (this.forFile) {
            resourceMode |= 1;
        }
        if (this.forDirectory) {
            resourceMode |= 2;
        }
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        SearchResourceDialog dialog = new SearchResourceDialog(this.getShell(), false, (IContainer)container, resourceMode);
        String initial = "";
        IFileStore store = this.validator.getFileStore();
        initial = store != null ? store.getName() : ((idx = (current = this.getText()).lastIndexOf(47)) >= 0 ? current.substring(idx + 1) : current);
        dialog.setInitialPattern(initial);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IResource resource = (IResource)results[0];
        if (!this.forFile && resource.getType() == 1) {
            resource = resource.getParent();
        }
        String wsPath = resource.getFullPath().toString();
        this.validator.setExplicit((Object)resource);
        this.setText(this.newVariableExpression(VAR_WORKSPACE_LOC, this.escapeText(wsPath)), false);
    }

    protected void handleBrowseWorkspaceButton(int mode) {
        String appendPath;
        String wsPath;
        IResource res = this.validator.getWorkspaceResource();
        if (res == null) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        }
        Object resource = null;
        if (mode == 2) {
            if (res instanceof IFile) {
                res = res.getParent();
            }
            ResourceContainerSelectionDialog dialog = new ResourceContainerSelectionDialog(this.getShell(), this.getTaskLabel());
            dialog.setInitialElementSelection(res);
            dialog.open();
            resource = dialog.getFirstResult();
            if (resource == null) {
                return;
            }
            wsPath = res.getFullPath().toString();
            appendPath = "";
        } else {
            ResourceFileSelectionDialog dialog = new ResourceFileSelectionDialog(this.getShell(), this.getTaskLabel());
            dialog.setInitialElementSelection(res);
            dialog.setAllowNewResources(this.validator.getOnNotExisting() != 4);
            dialog.open();
            resource = dialog.getFirstResult();
            if (resource == null) {
                return;
            }
            res = resource.getParent();
            StringBuilder path = new StringBuilder(resource.getName());
            path.insert(0, '/');
            while (!res.exists()) {
                res = res.getParent();
                path.insert(0, res.getName());
                path.insert(0, '/');
            }
            wsPath = res.getFullPath().toString();
            appendPath = path.toString();
        }
        this.validator.setExplicit(resource);
        if (this.wsOnly) {
            this.setText(this.escapeText(String.valueOf(wsPath) + appendPath), false);
        } else {
            this.setText(String.valueOf(this.newVariableExpression(VAR_WORKSPACE_LOC, this.escapeText(wsPath))) + this.escapeText(appendPath), false);
        }
    }

    protected void handleBrowseFilesystemButton(int mode) {
        String path = null;
        try {
            if (this.validator.isLocalFile()) {
                path = URIUtil.toPath((URI)this.validator.getFileStore().toURI()).toOSString();
            } else if (this.getText().isEmpty()) {
                path = this.defaultFilesystemPath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mode == 2) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            dialog.setText(MessageUtils.removeMnemonics(this.getTaskLabel()));
            dialog.setFilterPath(path);
            path = dialog.open();
        } else {
            FileDialog dialog = new FileDialog(this.getShell(), this.doOpen ? 4096 : 8192);
            dialog.setText(MessageUtils.removeMnemonics(this.getTaskLabel()));
            dialog.setFilterPath(path);
            if (this.fileFilters != null) {
                dialog.setFilterExtensions(this.fileFilters);
                dialog.setFilterNames(this.fileFilterNames);
            }
            path = dialog.open();
        }
        if (path == null) {
            return;
        }
        path = this.escapeText(path);
        this.validator.setExplicit((Object)path);
        this.setText(path, false);
    }

    protected void handleVariablesButton() {
        Map extraVariables;
        CustomizableVariableSelectionDialog dialog = new CustomizableVariableSelectionDialog(this.getShell());
        if (this.showInsertVariableFilters != null) {
            for (StringVariableSelectionDialog.VariableFilter filter : this.showInsertVariableFilters) {
                dialog.addVariableFilter(filter);
            }
        }
        if (this.showInsertVariableAdditionals != null) {
            dialog.setAdditionals((Collection<? extends IStringVariable>)this.showInsertVariableAdditionals);
        } else if (this.validator.getVariableResolver() != null && (extraVariables = this.validator.getVariableResolver().getExtraVariables()) != null) {
            dialog.setAdditionals(extraVariables.values());
        }
        if (dialog.open() != 0) {
            return;
        }
        String variable = dialog.getVariableExpression();
        if (variable == null) {
            return;
        }
        this.insertText(variable);
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        String path = null;
        if (this.wsOnly) {
            IResource resource = this.validator.getWorkspaceResource();
            if (resource != null) {
                path = resource.getFullPath().toString();
            }
        } else {
            IFileStore fileStore = this.validator.getFileStore();
            if (fileStore != null) {
                try {
                    path = this.validator.isLocalFile() ? URIUtil.toPath((URI)fileStore.toURI()).toOSString() : fileStore.toURI().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (path == null || path.isEmpty()) {
            path = "";
        }
        this.getTextControl().setToolTipText(path);
    }

    public String getResourceString() {
        return this.getText();
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.asCombo) {
            this.locationComboField.addModifyListener(listener);
        } else {
            this.locationTextField.addModifyListener(listener);
        }
    }

    public IResource getResourceAsWorkspaceResource() {
        return this.validator.getWorkspaceResource();
    }

    public IFileStore getResourceAsFileStore() {
        return this.validator.getFileStore();
    }

    public IObservableValue<String> getObservable() {
        if (this.asCombo) {
            return WidgetProperties.text().observe((Widget)this.locationComboField);
        }
        return WidgetProperties.text((int)24).observe((Widget)this.locationTextField);
    }

    public ObservableFileValidator getValidator() {
        return this.validator;
    }

    protected String newVariableExpression(String varName, String arg) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, arg);
    }

    protected void beforeMenuAction() {
    }

    protected void afterMenuAction() {
    }

    private static class SearchResourceDialog
    extends FilteredResourcesSelectionDialog {
        public SearchResourceDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
            super(shell, multi, container, typesMask);
            this.setTitle(Messages.ResourceSelectionDialog_title);
        }
    }
}

