/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers;

import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class AbstractPostSelectionProvider
implements IPostSelectionProvider {
    private final CopyOnWriteIdentityListSet<ISelectionChangedListener> selectionListeners = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<ISelectionChangedListener> postSelectionListeners = new CopyOnWriteIdentityListSet();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }

    protected void firePostSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.postSelectionListeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }
}

