/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

@NonNullByDefault
public class SearchContributionItem
extends ContributionItem {
    public static final int VIEW_TOOLBAR = 0x10000000;
    private final int options;
    private SearchText control = (SearchText)((Object)ObjectUtils.nonNullLateInit());
    private ToolItem textItem = (ToolItem)ObjectUtils.nonNullLateInit();
    private @Nullable String toolTipText;
    private @Nullable Composite sizeControl;
    private @Nullable Control resultControl;
    private final boolean updateWhenTyping;
    private final Runnable sizeCheckRunnable = new Runnable(){

        @Override
        public void run() {
            SearchContributionItem.this.sizeCheckScheduled = false;
            SearchContributionItem.this.resize();
        }
    };
    private boolean sizeCheckScheduled;

    public SearchContributionItem(String id, int options, boolean updateWhenTyping) {
        super(id);
        this.options = options;
        this.updateWhenTyping = updateWhenTyping;
    }

    public SearchContributionItem(String id, int options) {
        this(id, options, false);
    }

    public SearchText getSearchText() {
        return this.control;
    }

    public void setResultControl(@Nullable Control control) {
        this.resultControl = control;
    }

    public void setToolTip(@Nullable String text) {
        this.toolTipText = text;
    }

    public void setSizeControl(Composite control) {
        this.sizeControl = control;
        control.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SearchContributionItem.this.resize();
            }
        });
    }

    public void resize() {
        Composite sizeControl = this.sizeControl;
        if (this.textItem != null && !this.textItem.isDisposed() && sizeControl != null) {
            int width;
            Layout layout;
            int viewWidth = sizeControl.getClientArea().width;
            if (viewWidth <= 0) {
                return;
            }
            ToolBar toolBar = this.textItem.getParent();
            Composite toolBarParent = (Composite)ObjectUtils.nonNullAssert((Object)toolBar.getParent());
            int toolBarWidth = toolBar.computeSize((int)-1, (int)-1).x;
            int currentWidth = this.textItem.getWidth();
            int minWidth = LayoutUtils.hintWidth(this.control.getTextControl(), 8);
            int corr = toolBarWidth - currentWidth;
            if ((this.options & 0x10000000) != 0 && (layout = toolBarParent.getLayout()) instanceof RowLayout && ((RowLayout)layout).type == 256) {
                Control[] children = toolBarParent.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] != toolBar) {
                        corr += children[i].getSize().x;
                    }
                    ++i;
                }
                corr += (children.length - 1) * ((RowLayout)layout).spacing;
            }
            if ((width = Math.min(310, Math.max(minWidth, viewWidth - (corr += 16)))) == currentWidth) {
                return;
            }
            this.textItem.setWidth(width);
            toolBarParent.layout(new Control[]{this.control});
            if ((this.options & 0x10000000) != 0) {
                toolBarParent.pack(true);
                Composite viewComposite = (Composite)ObjectUtils.nonNullAssert((Object)toolBarParent.getParent());
                viewComposite.layout(new Control[]{toolBarParent});
            }
        }
    }

    private void scheduleSizeCheck() {
        if (!this.sizeCheckScheduled && this.textItem != null && !this.textItem.isDisposed()) {
            this.sizeCheckScheduled = true;
            this.textItem.getDisplay().asyncExec(this.sizeCheckRunnable);
        }
    }

    public void fill(ToolBar parent, int index) {
        this.control = new SearchText((Composite)parent);
        this.control.addListener(this.createSearchTextListener());
        SWTListener swtListener = new SWTListener();
        this.control.addListener(11, swtListener);
        this.control.setToolTipText(this.toolTipText);
        this.textItem = new ToolItem(parent, 2, index);
        this.textItem.setControl((Control)this.control);
        this.textItem.setToolTipText(this.toolTipText);
        this.textItem.setWidth(310);
    }

    public Control create(Composite parent) {
        this.control = new SearchText(parent);
        this.control.addListener(this.createSearchTextListener());
        SWTListener swtListener = new SWTListener();
        this.control.addListener(11, swtListener);
        this.control.setToolTipText(this.toolTipText);
        return this.control;
    }

    protected SearchText.Listener createSearchTextListener() {
        return new SearchText.Listener(){

            @Override
            public void textChanged(boolean user) {
                if (SearchContributionItem.this.updateWhenTyping || !user) {
                    SearchContributionItem.this.search();
                }
            }

            @Override
            public void okPressed() {
                SearchContributionItem.this.search();
            }

            @Override
            public void downPressed() {
                SearchContributionItem.this.selectFirst();
            }
        };
    }

    protected void search() {
    }

    protected void selectFirst() {
        Control resultControl = this.resultControl;
        if (resultControl instanceof Table) {
            int idx;
            Table table = (Table)resultControl;
            table.setFocus();
            if (table.getSelectionCount() == 0 && (idx = table.getTopIndex()) >= 0) {
                table.setSelection(idx);
            }
        } else if (resultControl instanceof Tree) {
            TreeItem item;
            Tree table = (Tree)resultControl;
            table.setFocus();
            if (table.getSelectionCount() == 0 && (item = table.getTopItem()) != null) {
                table.setSelection(item);
            }
        }
    }

    public String getText() {
        return this.control.getText();
    }

    public void show() {
        if (!UIAccess.isOkToUse((Control)this.control)) {
            return;
        }
        this.control.setFocus();
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    SearchContributionItem.this.scheduleSizeCheck();
                    return;
                }
            }
        }
    }
}

