/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectDef;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceObjectController;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class PreferenceObjectCache
implements PreferenceObjectAccess {
    private final Map<String, TypeItem<?>> map = new HashMap();

    public abstract PreferenceAccess getPrefs();

    protected <TObject> @Nullable PreferenceObjectController<TObject> createPreferenceObjectController(Class<TObject> type) {
        return null;
    }

    protected <TObject> PreferenceObjectController<TObject> createPreferenceObjectController(Class<TObject> type, final PreferenceObjectDef<TObject> def) {
        return new PreferenceObjectController<TObject>(type, this.getPrefs(), def.getQualifiers()){

            @Override
            protected TObject createObject(PreferenceAccess prefs) {
                return def.create(prefs);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TObject> TypeItem<TObject> getTypeItem(Class<TObject> type, @Nullable PreferenceObjectDef<TObject> def) {
        String typeName = type.getName();
        Map<String, TypeItem<?>> map = this.map;
        synchronized (map) {
            TypeItem<Object> typeItem = this.map.get(typeName);
            if (typeItem == null) {
                typeItem = new TypeItem<TObject>(type, def != null ? this.createPreferenceObjectController(type, def) : this.createPreferenceObjectController(type));
                this.map.put(typeName, typeItem);
            }
            return typeItem;
        }
    }

    @Override
    public <TObject> @Nullable TObject getPreferenceObject(Class<TObject> type) {
        return this.getTypeItem(type, null).get();
    }

    @Override
    public <TObject> TObject getPreferenceObject(PreferenceObjectDef<TObject> def) {
        return this.getTypeItem(def.getType(), def).get();
    }

    public <TObject> void addPreferenceObject(PreferenceObjectDef<TObject> def) {
        this.getTypeItem(def.getType(), def);
    }

    private static class TypeItem<TObject> {
        private final Class<TObject> type;
        private final @Nullable PreferenceObjectController<TObject> controller;

        public TypeItem(Class<TObject> type, @Nullable PreferenceObjectController<TObject> controller) {
            this.type = type;
            this.controller = controller;
        }

        public @Nullable TObject get() {
            return this.controller != null ? (TObject)this.controller.get() : null;
        }

        public String toString() {
            return this.type.toString();
        }
    }
}

