/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.net.core;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.internal.ecommons.net.core.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.WarningStatus;

@NonNullByDefault
public class ESshSettings
implements Disposable {
    private static final String EJSCH_QUALIFIER = "org.eclipse.jsch.core";
    private static final Preference<@Nullable String> SSH_DATA_DIRECTORY_PATH_PREF = new Preference.NullableStringPref("org.eclipse.jsch.core", "SSH2HOME");
    private static final Preference<List<String>> DEFAULT_IDENTITY_NAMES_PREF = new Preference.StringListPref("org.eclipse.jsch.core", "PRIVATEKEY", ',');
    private static final Preference<@Nullable String> PREFERRED_AUTHENTICATION_METHODS_LIST_STRING_PREF = new Preference.NullableStringPref("org.eclipse.jsch.core", "CVSSSH2PreferencePage.PREF_AUTH_METHODS");
    private static final String EGIT_QUALIFIER = "org.eclipse.egit.core";
    private static final Preference.BooleanPref IDENTITY_AGENT_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.egit.core", "core_ssh_agent", true);
    private static final Preference<@Nullable String> IDENTITY_AGENT_DEFAULT_PREF = new Preference.NullableStringPref("org.eclipse.egit.core", "core_ssh_default_agent");
    private static final Preference.BooleanPref SAVE_CREDITALS_IN_SECURE_STORE_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.egit.core", "core_save_credentials_in_secure_store", true);
    private final PreferenceAccess prefs;
    private final IEclipsePreferences.IPreferenceChangeListener prefsListener;
    private @Nullable Path sshDataDirectory;
    private @Nullable ImList<String> defaultIdentityNames;
    private @Nullable String preferredAuthenticationMethodsString;

    public ESshSettings(PreferenceAccess prefs) {
        this.prefs = prefs;
        this.prefsListener = this::preferenceChange;
        this.prefs.addPreferenceNodeListener(EJSCH_QUALIFIER, this.prefsListener);
        this.reload();
    }

    public void dispose() {
        this.prefs.removePreferenceNodeListener(EJSCH_QUALIFIER, this.prefsListener);
    }

    protected void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.reload();
    }

    protected void reload() {
        Object value = (String)this.prefs.getPreferenceValue(SSH_DATA_DIRECTORY_PATH_PREF);
        Path path = null;
        if (value != null && !((String)value).isEmpty()) {
            try {
                path = Path.of((String)value, new String[0]);
            }
            catch (InvalidPathException e) {
                CommonsRuntime.log((Status)new WarningStatus("org.eclipse.statet.ecommons.net.core", NLS.bind((String)Messages.SshSession_SshDataDir_error_Invalid_message, (Object)value), (Throwable)e));
            }
        }
        this.sshDataDirectory = path;
        value = (List)this.prefs.getPreferenceValue(DEFAULT_IDENTITY_NAMES_PREF);
        ImList names = null;
        if (!value.isEmpty()) {
            Object[] checked = new String[value.size()];
            int n = 0;
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if ((name = name.trim()).isEmpty()) continue;
                try {
                    Path.of(name, new String[0]);
                    checked[n++] = name;
                }
                catch (InvalidPathException e) {
                    CommonsRuntime.log((Status)new WarningStatus("org.eclipse.statet.ecommons.net.core", NLS.bind((String)Messages.SshSession_IdentityKey_error_Invalid_message, (Object)value), (Throwable)e));
                }
            }
            names = ImCollections.newList((Object[])checked, (int)0, (int)n);
        }
        this.defaultIdentityNames = names;
        value = (String)this.prefs.getPreferenceValue(PREFERRED_AUTHENTICATION_METHODS_LIST_STRING_PREF);
        Object string = null;
        if (value != null && !((String)value).isEmpty()) {
            string = value;
        }
        this.preferredAuthenticationMethodsString = string;
    }

    public @Nullable Path getSshDataDirectory() {
        return this.sshDataDirectory;
    }

    public @Nullable ImList<String> getDefaultIdentityNames() {
        return this.defaultIdentityNames;
    }

    public @Nullable String getPreferredAuthenticationMethodsString() {
        return this.preferredAuthenticationMethodsString;
    }

    public boolean isUseIdentityAgentEnabled() {
        return (Boolean)this.prefs.getPreferenceValue((Preference)IDENTITY_AGENT_ENABLED_PREF);
    }

    public @Nullable String getDefaultIdentityAgent() {
        return (String)this.prefs.getPreferenceValue(IDENTITY_AGENT_DEFAULT_PREF);
    }

    public boolean getSaveCredentialsInSecureStore() {
        return (Boolean)this.prefs.getPreferenceValue((Preference)SAVE_CREDITALS_IN_SECURE_STORE_ENABLED_PREF);
    }

    public void setSaveCredentialsInSecureStore(boolean enabled) {
        PreferenceUtils.setPrefValue((IScopeContext)((IScopeContext)this.prefs.getPreferenceContexts().get(0)), (Preference)SAVE_CREDITALS_IN_SECURE_STORE_ENABLED_PREF, (Object)enabled, (int)3);
    }
}

