/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.AutoLinkSpan;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Link;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class AutoLinkWithoutDemarcationSpan
extends SourceSpan {
    private static final Pattern PATTERN = Pattern.compile("(https?://[\\p{Alnum}%._~!$&?#'()*+,;:@/=-]*[\\p{Alnum}_~!$&?#'(*+@/=-]).*", 32);
    private final Matcher matcher = PATTERN.matcher("");

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher matcher;
        if (cursor.getChar() == 'h' && (matcher = cursor.setup(this.matcher)).matches()) {
            String link;
            String href = link = matcher.group(1);
            int cursorLength = matcher.end(1) - matcher.regionStart();
            int startOffset = cursor.getOffset();
            return new Link(cursor.getLineAtOffset(), startOffset, cursorLength, cursorLength, AutoLinkSpan.encodeLinkUri(link), null, (List<? extends Inline>)ImCollections.newList((Object)new Characters(cursor.getLineAtOffset(), startOffset, cursorLength, cursorLength, href)));
        }
        return null;
    }
}

