/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core;

import java.util.List;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceStore;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.issues.core.TaskPriority;
import org.eclipse.statet.ltk.issues.core.TaskTag;
import org.eclipse.statet.ltk.issues.core.impl.BasicTaskTag;

@NonNullByDefault
public final class Issues {
    static final String TASK_TAG_QUALIFIER = "org.eclipse.statet.ide.core/managment";
    public static final String TASK_TAG_KEYWORD_PREF_KEY = "TaskTags.keyword";
    public static final String TASK_TAG_PRIORITY_PREF_KEY = "TaskTags.priority";
    public static final Preference<List<String>> TASK_TAG_KEYWORD_PREF = new Preference.StringListPref("org.eclipse.statet.ide.core/managment", "TaskTags.keyword");
    public static final Preference<List<TaskPriority>> TASK_TAG_PRIORITY_PREF = new Preference.EnumListPref("org.eclipse.statet.ide.core/managment", "TaskTags.priority", TaskPriority.class);

    public static ImList<TaskTag> loadTaskTags(PreferenceAccess prefs, Preference<List<String>> keywordPerf, Preference<List<TaskPriority>> priorityPref) {
        List keywords = (List)prefs.getPreferenceValue(keywordPerf);
        List priorities = (List)prefs.getPreferenceValue(priorityPref);
        if (keywords.size() == priorities.size()) {
            Object[] array = new TaskTag[keywords.size()];
            int i = 0;
            while (i < array.length) {
                array[i] = new BasicTaskTag((String)keywords.get(i), (TaskPriority)((Object)priorities.get(i)));
                ++i;
            }
            return ImCollections.newList((Object[])array);
        }
        return ImCollections.emptyList();
    }

    @Deprecated
    public static ImList<TaskTag> loadTaskTags(PreferenceAccess prefs) {
        return Issues.loadTaskTags(prefs, TASK_TAG_KEYWORD_PREF, TASK_TAG_PRIORITY_PREF);
    }

    public static void saveTaskTags(ImList<TaskTag> taskTags, PreferenceStore prefs, Preference<List<String>> keywordPerf, Preference<List<TaskPriority>> priorityPref) {
        prefs.setPreferenceValue(keywordPerf, (Object)taskTags.map(TaskTag::getKeyword).toList());
        prefs.setPreferenceValue(priorityPref, (Object)taskTags.map(TaskTag::getPriority).toList());
    }
}

