/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh.jsch;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Map;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.TunnelClientSocketImpl;
import org.eclipse.statet.jcommons.net.core.ssh.BasicSshClientSession;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.util.TimeUtils;

@NonNullByDefault
public abstract class JSchClientSession
extends BasicSshClientSession<Session> {
    public JSchClientSession(SshTarget target, @Nullable Duration timeout) {
        super(target, timeout);
    }

    protected boolean isConnected(Session session) {
        return session.isConnected();
    }

    protected void disconnect(@Nullable Session session) {
        if (session != null) {
            session.disconnect();
        }
    }

    protected RemoteProcess exec(Session session, ProcessConfig processConfig, @Nullable Duration timeout, ProgressMonitor m) throws Exception {
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        if (channel == null) {
            throw new IOException("Failed to create SSH 'exec' channel");
        }
        channel.setCommand(processConfig.getCommandString());
        for (Map.Entry entry : processConfig.getEnvironmentVars().entrySet()) {
            channel.setEnv((String)entry.getKey(), (String)entry.getValue());
        }
        channel.setInputStream(processConfig.getInputStream());
        channel.setOutputStream((OutputStream)ObjectUtils.nonNullElse((Object)processConfig.getOutputStream(), (Object)IOUtils.NULL_OUTPUT_STREAM), false);
        channel.setErrStream((OutputStream)ObjectUtils.nonNullElse((Object)processConfig.getOutputStream(), (Object)IOUtils.NULL_OUTPUT_STREAM), false);
        channel.connect(TimeUtils.toMillisInt((Duration)timeout, (int)0));
        return new JSchExecProcess(processConfig.getCommandString(), channel);
    }

    protected TunnelClientSocketImpl createDirectTcpIpSocketImpl(Session session) throws Exception {
        return new JSchTunnelClientSocketImpl(session);
    }

    protected InetSocketAddress startPortForwardingL(Session session, InetSocketAddress targetAddress, @Nullable Duration timeout) throws Exception {
        String localHostString = CommonsNet.LOCAL_LOOPBACK_STRING;
        int localPortNum = session.setPortForwardingL(localHostString, 0, targetAddress.getHostString(), targetAddress.getPort(), null, TimeUtils.toMillisInt((Duration)timeout, (int)0));
        return new InetSocketAddress(localHostString, localPortNum);
    }

    protected void stopPortForwardingL(Session session, InetSocketAddress targetAddress, InetSocketAddress localAddress, @Nullable Duration timeout) throws Exception {
        session.delPortForwardingL(localAddress.getHostString(), localAddress.getPort());
    }

    private static class JSchExecProcess
    extends RemoteProcess {
        private final ChannelExec channel;

        public JSchExecProcess(String command, ChannelExec channel) {
            super(command);
            this.channel = channel;
        }

        public boolean isAlive() {
            return this.channel.isConnected() && this.channel.getExitStatus() < 0;
        }

        public int getExitStatusCode() {
            boolean closed = !this.channel.isConnected();
            int statusCode = this.channel.getExitStatus();
            if (statusCode < 0) {
                if (closed) {
                    return -1;
                }
                throw new IllegalThreadStateException("The process has not terminated");
            }
            return statusCode;
        }

        public void close() {
            this.channel.disconnect();
        }
    }

    private static class JSchTunnelClientSocketImpl
    extends TunnelClientSocketImpl {
        private final Session session;
        private volatile @Nullable ChannelDirectTCPIP channel;

        public JSchTunnelClientSocketImpl(Session session) throws IOException {
            this.session = session;
            this.tcpNoDelay = true;
        }

        protected void connectRemote(InetSocketAddress targetAddress, @Nullable Duration timeout, ProgressMonitor m) throws IOException, StatusException {
            try {
                ChannelDirectTCPIP channel = (ChannelDirectTCPIP)this.session.openChannel("direct-tcpip");
                if (channel == null) {
                    throw new IOException("Failed to create SSH 'direct-tcpip' channel");
                }
                channel.setHost(targetAddress.getHostString());
                channel.setPort(targetAddress.getPort());
                PipedInputStream inputStream = new PipedInputStream(32768);
                channel.setOutputStream((OutputStream)new PipedOutputStream(inputStream));
                this.setInputStream(inputStream);
                this.setOutputStream(channel.getOutputStream());
                this.channel = channel;
                channel.connect(TimeUtils.toMillisInt((Duration)timeout, (int)0));
            }
            catch (JSchException e) {
                IOException ioException = new IOException();
                ioException.initCause(e);
                throw ioException;
            }
        }

        protected void close() throws IOException {
            super.close();
            ChannelDirectTCPIP channel = this.channel;
            if (channel == null) {
                return;
            }
            channel.disconnect();
        }
    }
}

