/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze.swt;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.layer.CompositeLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeConfigAttributes;
import org.eclipse.statet.ecommons.waltable.freeze.core.CompositeFreezeLayer;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

@NonNullByDefault
public class CompositeFreezeLayerPainter
extends CompositeLayer.CompositeLayerPainter {
    public CompositeFreezeLayerPainter(CompositeFreezeLayer layer) {
        super(layer);
    }

    protected Layer getFreezeLayer() {
        return this.layer.getChildLayerByLayoutCoordinate(0, 0);
    }

    @Override
    public void paintLayer(Layer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, ConfigRegistry configRegistry) {
        long freezeHeight;
        super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        Layer freezeLayer = this.getFreezeLayer();
        Color separatorColor = configRegistry.getAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR, DisplayMode.NORMAL, new String[0]);
        if (separatorColor == null) {
            separatorColor = GUIHelper.COLOR_BLUE;
        }
        gc.setClipping(rectangle);
        Color oldFg = gc.getForeground();
        gc.setForeground(separatorColor);
        long freezeWidth = freezeLayer.getWidth() - 1L;
        if (freezeWidth > 0L) {
            gc.drawLine(GraphicsUtils.safe((long)xOffset + freezeWidth), yOffset, GraphicsUtils.safe((long)xOffset + freezeWidth), GraphicsUtils.safe((long)yOffset + this.layer.getHeight() - 1L));
        }
        if ((freezeHeight = freezeLayer.getHeight() - 1L) > 0L) {
            gc.drawLine(xOffset, GraphicsUtils.safe((long)yOffset + freezeHeight), GraphicsUtils.safe((long)xOffset + this.layer.getWidth() - 1L), GraphicsUtils.safe((long)yOffset + freezeHeight));
        }
        gc.setForeground(oldFg);
    }
}

