/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.net.core.jsch;

import com.jcraft.jsch.Session;
import java.time.Duration;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.statet.internal.ecommons.net.core.ECommonsNetCorePlugin;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.core.ssh.BasicSshClientSessionFactory;
import org.eclipse.statet.jcommons.net.core.ssh.SshClientSession;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.net.core.ssh.jsch.JSchClientSession;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.util.TimeUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

@NonNullByDefault
public class EJSchClientSessionFactory
extends BasicSshClientSessionFactory
implements Disposable {
    private static final Version REQ_JSCH_VERSION = new Version(0, 1, 49);
    private final ServiceTracker<IJSchService, ?> sshJSchTracker;

    public EJSchClientSessionFactory() throws StatusException {
        BundleContext context = ECommonsNetCorePlugin.getInstance().getBundle().getBundleContext();
        this.sshJSchTracker = new ServiceTracker(context, IJSchService.class, null);
        this.sshJSchTracker.open();
        Bundle bundle = Platform.getBundle((String)"com.jcraft.jsch");
        if (bundle != null && bundle.getVersion().compareTo(REQ_JSCH_VERSION) < 0) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.ecommons.net.core", 0, "The installed version of the Java Secure Channel Library 'JSch' by JCraft is outdated.\nPlease install version " + REQ_JSCH_VERSION + " or newer, " + "for example from the update-site of Eclipse StatET."));
        }
    }

    public void dispose() {
        this.sshJSchTracker.close();
    }

    protected IJSchService getJSchService() throws StatusException {
        return (IJSchService)this.sshJSchTracker.getService();
    }

    protected SshClientSession createSession(SshTarget target, @Nullable Duration timeout, ProgressMonitor m) throws StatusException {
        m.setWorkRemaining(4);
        final IJSchService jschService = this.getJSchService();
        final IJSchLocation jschLocation = jschService.getLocation(target.getUsername(), target.getHost(), target.getPortNum());
        JSchClientSession session = new JSchClientSession(target, timeout){

            protected Session connect(@Nullable Duration timeout, ProgressMonitor m) throws Exception {
                Session jschSession = jschService.createSession(jschLocation, null);
                try {
                    jschService.connect(jschSession, TimeUtils.toMillisInt((Duration)timeout, (int)0), EStatusUtils.convert((ProgressMonitor)m));
                    return jschSession;
                }
                catch (Exception e) {
                    EJSchClientSessionFactory.close(jschSession, e);
                    throw e;
                }
            }
        };
        m.addWorked(1);
        session.connect(m);
        return session;
    }

    public static void close(@Nullable Session toClose, Throwable exception) {
        if (toClose != null) {
            try {
                toClose.disconnect();
            }
            catch (Exception e) {
                exception.addSuppressed(e);
            }
        }
    }
}

