/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class SetOperatorNode
extends TableOperatorNode {
    boolean all;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();
    private PredicateList leftOptPredicates;
    private PredicateList rightOptPredicates;
    private PredicateList pushedPredicates;
    private HashMap<Predicate, Predicate> leftScopedPreds;
    private HashMap<Predicate, Predicate> rightScopedPreds;

    SetOperatorNode(ResultSetNode resultSetNode, ResultSetNode resultSetNode2, boolean bl, Properties properties, ContextManager contextManager) throws StandardException {
        super(resultSetNode, resultSetNode2, properties, contextManager);
        this.all = bl;
        this.setResultColumns(this.leftResultSet.getResultColumns().copyListAndObjects());
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet, PredicateList predicateList) throws StandardException {
        if (predicateList != null && !this.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predicateList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predicateList.getOptPredicate(i))) continue;
                predicateList.removeOptPredicate(i);
            }
        }
        CostEstimate costEstimate = this.getFinalCostEstimate();
        Object object = (ResultSetNode)((Object)this.modifyAccessPath(jBitSet));
        CollectNodesVisitor<UnionNode> collectNodesVisitor = new CollectNodesVisitor<UnionNode>(UnionNode.class);
        this.accept(collectNodesVisitor);
        boolean bl = false;
        for (UnionNode unionNode : collectNodesVisitor.getList()) {
            if (!unionNode.hasUnPushedPredicates()) continue;
            bl = true;
            break;
        }
        if (bl) {
            ProjectRestrictNode projectRestrictNode = new ProjectRestrictNode((ResultSetNode)object, ((ResultSetNode)object).getResultColumns(), null, this.pushedPredicates, null, null, null, this.getContextManager());
            projectRestrictNode.setCostEstimate(costEstimate.cloneMe());
            projectRestrictNode.setReferencedTableMap(((ResultSetNode)object).getReferencedTableMap());
            object = projectRestrictNode;
        }
        return (Optimizable)object;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        boolean bl;
        if (!(this instanceof UnionNode)) {
            return false;
        }
        Predicate predicate = (Predicate)optimizablePredicate;
        if (!predicate.pushableToSubqueries()) {
            return false;
        }
        JBitSet jBitSet = new JBitSet(this.getReferencedTableMap().size());
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet);
        this.leftResultSet.accept(baseTableNumbersVisitor);
        boolean bl2 = bl = jBitSet.getFirstSetBit() != -1;
        if (!bl) {
            return false;
        }
        jBitSet.clearAll();
        this.rightResultSet.accept(baseTableNumbersVisitor);
        boolean bl3 = bl = jBitSet.getFirstSetBit() != -1;
        if (!bl) {
            return false;
        }
        jBitSet.clearAll();
        this.accept(baseTableNumbersVisitor);
        int[] nArray = new int[]{-1};
        Predicate predicate2 = null;
        if (this.leftScopedPreds == null) {
            this.leftScopedPreds = new HashMap();
        } else {
            predicate2 = this.leftScopedPreds.get(predicate);
        }
        if (predicate2 == null) {
            predicate2 = predicate.getPredScopedForResultSet(jBitSet, this.leftResultSet, nArray);
            this.leftScopedPreds.put(predicate, predicate2);
        }
        this.getLeftOptPredicateList().addOptPredicate(predicate2);
        predicate2 = null;
        if (this.rightScopedPreds == null) {
            this.rightScopedPreds = new HashMap();
        } else {
            predicate2 = this.rightScopedPreds.get(predicate);
        }
        if (predicate2 == null) {
            predicate2 = predicate.getPredScopedForResultSet(jBitSet, this.rightResultSet, nArray);
            this.rightScopedPreds.put(predicate, predicate2);
        }
        this.getRightOptPredicateList().addOptPredicate(predicate2);
        if (this.pushedPredicates == null) {
            this.pushedPredicates = new PredicateList(this.getContextManager());
        }
        this.pushedPredicates.addOptPredicate(predicate);
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (this.pushedPredicates == null) {
            return;
        }
        if (this.leftOptPredicates != null) {
            this.leftOptPredicates.removeAllElements();
        }
        if (this.rightOptPredicates != null) {
            this.rightOptPredicates.removeAllElements();
        }
        RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(false);
        for (int i = 0; i < this.pushedPredicates.size(); ++i) {
            Predicate predicate = (Predicate)this.pushedPredicates.getOptPredicate(i);
            if (predicate.isScopedForPush()) {
                predicate.getAndNode().accept(remapCRsVisitor);
                continue;
            }
            optimizablePredicateList.addOptPredicate(predicate);
        }
        this.pushedPredicates.removeAllElements();
    }

    protected boolean hasUnPushedPredicates() {
        return this.leftOptPredicates != null && this.leftOptPredicates.size() > 0 || this.rightOptPredicates != null && this.rightOptPredicates.size() > 0;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    void bindResultColumns(FromList fromList) throws StandardException {
        super.bindResultColumns(fromList);
        this.buildRCL();
    }

    @Override
    void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.buildRCL();
    }

    private void buildRCL() throws StandardException {
        if (this.leftResultSet.getResultColumns().visibleSize() != this.rightResultSet.getResultColumns().visibleSize()) {
            throw StandardException.newException("42X58", this.getOperatorName());
        }
        this.setResultColumns(this.leftResultSet.getResultColumns().copyListAndObjects());
        this.getResultColumns().removeGeneratedGroupingColumns();
        this.getResultColumns().removeOrderByColumns();
        this.getResultColumns().setUnionResultExpression(this.rightResultSet.getResultColumns(), this.tableNumber, this.level, this.getOperatorName());
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            ResultColumnList resultColumnList2 = this.rightResultSet.getResultColumns();
            ResultColumnList resultColumnList3 = this.leftResultSet.getResultColumns();
            this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList3);
            this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList2);
        } else {
            this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList);
            this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList);
        }
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl) throws StandardException {
        this.leftResultSet.replaceOrForbidDefaults(tableDescriptor, resultColumnList, bl);
        this.rightResultSet.replaceOrForbidDefaults(tableDescriptor, resultColumnList, bl);
    }

    int getParamColumnTypes(DataTypeDescriptor[] dataTypeDescriptorArray, RowResultSetNode rowResultSetNode) throws StandardException {
        int n = 0;
        for (int i = 0; i < dataTypeDescriptorArray.length; ++i) {
            ResultColumn resultColumn;
            if (dataTypeDescriptorArray[i] != null || (resultColumn = (ResultColumn)rowResultSetNode.getResultColumns().elementAt(i)).getExpression().requiresTypeFromContext()) continue;
            dataTypeDescriptorArray[i] = resultColumn.getExpression().getTypeServices();
            ++n;
        }
        return n;
    }

    void setParamColumnTypes(DataTypeDescriptor[] dataTypeDescriptorArray, RowResultSetNode rowResultSetNode) throws StandardException {
        ResultColumnList resultColumnList = rowResultSetNode.getResultColumns();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (!resultColumn.getExpression().requiresTypeFromContext()) continue;
            resultColumn.getExpression().setType(dataTypeDescriptorArray[i]);
        }
    }

    @Override
    public void bindExpressions(FromList fromList) throws StandardException {
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList != null) {
                orderByList.bindOrderByColumns(this);
                orderByList.pullUpOrderByColumns(this);
            }
            SetOperatorNode.bindOffsetFetch(this.qec.getOffset(i), this.qec.getFetchFirst(i));
        }
        super.bindExpressions(fromList);
    }

    @Override
    void bindTargetExpressions(FromList fromList) throws StandardException {
        this.leftResultSet.bindTargetExpressions(fromList);
        this.rightResultSet.bindTargetExpressions(fromList);
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
        this.qec.setOffset(valueNode);
        this.qec.setFetchFirst(valueNode2);
        this.qec.setHasJDBCLimitClause(bl);
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        SetOperatorNode setOperatorNode = this;
        this.leftResultSet = this.leftResultSet.preprocess(n, groupByList, fromList);
        this.rightResultSet = this.rightResultSet.preprocess(n, groupByList, fromList);
        this.setReferencedTableMap((JBitSet)this.leftResultSet.getReferencedTableMap().clone());
        this.getReferencedTableMap().or(this.rightResultSet.getReferencedTableMap());
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (!this.all && orderByList != null && orderByList.allAscending() && orderByList.isInOrderPrefix(this.getResultColumns())) {
                orderByList = null;
                this.qec.setOrderByList(i, null);
            }
            if (orderByList == null || orderByList.size() <= 1) continue;
            orderByList.removeDupColumns();
        }
        return setOperatorNode;
    }

    @Override
    ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this.genProjectRestrict(n);
    }

    @Override
    void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
        this.leftResultSet.verifySelectStarSubquery(fromList, n);
        this.rightResultSet.verifySelectStarSubquery(fromList, n);
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.leftResultSet.getFromTableByName(string, string2, bl);
    }

    @Override
    ResultSetNode setResultToBooleanTrueNode(boolean bl) throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList.addFromTable(this);
        fromList.markAsTransparent();
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        AllResultColumn allResultColumn = new AllResultColumn(null, this.getContextManager());
        resultColumnList.addResultColumn(allResultColumn);
        SelectNode selectNode = new SelectNode(resultColumnList, fromList, null, null, null, null, null, this.getContextManager());
        return selectNode.setResultToBooleanTrueNode(bl);
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return false;
    }

    abstract String getOperatorName();

    PredicateList getLeftOptPredicateList() throws StandardException {
        if (this.leftOptPredicates == null) {
            this.leftOptPredicates = new PredicateList(this.getContextManager());
        }
        return this.leftOptPredicates;
    }

    PredicateList getRightOptPredicateList() throws StandardException {
        if (this.rightOptPredicates == null) {
            this.rightOptPredicates = new PredicateList(this.getContextManager());
        }
        return this.rightOptPredicates;
    }
}

