/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.variables.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.collections.ImCollections;

public class VariableText {
    private static final List<String> LOCATION_VARIABLES = ImCollections.newList((Object[])new String[]{"resource_loc", "selected_resource_loc", "container_loc", "project_loc"});
    private String text;
    private int state;
    private final List<String> specialVariablesNames;
    private List<IDynamicVariable> specialVariables;
    private final Set<String> unresolvedSpecial = new HashSet<String>();
    private final Map<String, String> locationVariables = new HashMap<String, String>();

    private static boolean isEscaped(String text, int offset) {
        int count = 1;
        while (offset >= count) {
            char c = text.charAt(offset - count);
            if (c != '$') break;
            ++count;
        }
        return count % 2 == 0;
    }

    private static void searchSurrounding(String text, int[] region) {
        while (region[0] != 0) {
            char c1 = text.charAt(region[0] - 1);
            if (c1 != ':') {
                return;
            }
            int start = text.lastIndexOf("${", region[0] - 1);
            if (start < 0 || text.lastIndexOf("}", region[0] - 1) > start || VariableText.isEscaped(text, start)) {
                return;
            }
            region[0] = start;
            int end = text.indexOf(125, region[1]);
            if (end < 0) continue;
            region[1] = end + 1;
        }
        return;
    }

    public VariableText(String text, List<String> specialVariablesNames) {
        this.specialVariablesNames = specialVariablesNames;
        this.text = text;
        this.state = 1;
    }

    public VariableText(String text, List<IDynamicVariable> checkedVariables, boolean useDirectly) {
        ArrayList<String> specialVariablesNames = new ArrayList<String>(checkedVariables.size());
        for (IStringVariable iStringVariable : checkedVariables) {
            specialVariablesNames.add(iStringVariable.getName());
        }
        this.specialVariablesNames = specialVariablesNames;
        if (useDirectly) {
            this.specialVariables = checkedVariables;
        }
        this.text = text;
        this.state = 1;
    }

    public String getText() {
        return this.text;
    }

    public void performInitialStringSubstitution(boolean reportUndefinedVariables) throws CoreException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        String text = this.text;
        LinkedHashMap<String, String> specialVariables = new LinkedHashMap<String, String>();
        for (String variableName : this.specialVariablesNames) {
            String pattern = "${" + variableName;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                int length;
                if (VariableText.isEscaped(text, offset)) continue;
                switch (offset + pattern.length() < text.length() ? (int)text.charAt(offset + pattern.length()) : 0) {
                    case 125: {
                        length = pattern.length() + 1;
                        break;
                    }
                    case 58: {
                        length = text.indexOf(125, offset + pattern.length()) - offset + 1;
                        if (length > 0) break;
                    }
                    default: {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)"Malformed variable expression: variable ''{0}'' not closed.", (Object)variableName)));
                    }
                }
                this.unresolvedSpecial.add(variableName);
                int[] region = new int[]{offset, offset + length};
                VariableText.searchSurrounding(text, region);
                String key = "XX-SPECIALVAR-" + specialVariables.size() + "-XX";
                specialVariables.put(key, new String(text.substring(region[0], region[1])));
                text = String.valueOf(text.substring(0, region[0])) + key + text.substring(region[1]);
            }
        }
        text = this.searchResourceVar(text, reportUndefinedVariables);
        text = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text, reportUndefinedVariables);
        Map.Entry[] entries = specialVariables.entrySet().toArray(new Map.Entry[specialVariables.size()]);
        int i = entries.length - 1;
        while (i >= 0) {
            text = text.replace((CharSequence)entries[i].getKey(), (CharSequence)entries[i].getValue());
            --i;
        }
        this.text = text;
        if (this.specialVariables != null) {
            for (IDynamicVariable variable : this.specialVariables) {
                if (!this.require(variable.getName())) continue;
                this.set(variable);
            }
        }
        this.state = 2;
    }

    private String searchResourceVar(String text, boolean reportUndefinedVariables) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        for (String variableName : LOCATION_VARIABLES) {
            String pattern = "${" + variableName;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                if (VariableText.isEscaped(text, offset)) continue;
                int end = text.indexOf(125, offset);
                int next = offset + 1;
                while ((next = text.indexOf(123, next + 1)) >= 0 && next < end) {
                    end = text.indexOf(125, end + 1);
                }
                String key = "XX-RESOURCEVAR-" + this.locationVariables.size() + "-XX";
                this.locationVariables.put(key, new String(variableManager.performStringSubstitution(text.substring(offset, end + 1), reportUndefinedVariables)));
                text = String.valueOf(text.substring(0, offset)) + key + text.substring(end + 1);
            }
        }
        return text;
    }

    public boolean require(String variableName) {
        return this.unresolvedSpecial.contains(variableName);
    }

    public void set(String variableName, String value) {
        if (this.unresolvedSpecial.remove(variableName)) {
            String pattern = "${" + variableName + "}";
            String text = this.text;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                if (VariableText.isEscaped(text, offset)) continue;
                text = String.valueOf(text.substring(0, offset)) + value + text.substring(offset + pattern.length());
            }
            this.text = text;
        }
    }

    public void set(IDynamicVariable variable) throws CoreException {
        if (this.unresolvedSpecial.remove(variable.getName())) {
            String pattern = "${" + variable.getName();
            String text = this.text;
            int offset = -1;
            while ((offset = text.indexOf(pattern, offset + 1)) >= 0) {
                String value;
                int length;
                if (VariableText.isEscaped(text, offset)) continue;
                switch (text.charAt(offset + pattern.length())) {
                    case '}': {
                        length = pattern.length() + 1;
                        value = variable.getValue(null);
                        break;
                    }
                    case ':': {
                        if (!variable.supportsArgument()) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)"Malformed variable expression: variable ''{0}'' doesn't support arguments.", (Object)variable.getName())));
                        }
                        length = text.indexOf(125, offset + pattern.length()) - offset + 1;
                        value = variable.getValue(text.substring(offset + pattern.length() + 1, offset + length - 1));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                text = String.valueOf(text.substring(0, offset)) + value + text.substring(offset + length);
            }
            this.text = text;
        }
    }

    public void performFinalStringSubstitution(LocationProcessor locationProcessor) throws CoreException {
        if (!this.unresolvedSpecial.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", "Unresolved variable(s): " + this.unresolvedSpecial.toString() + "."));
        }
        if (this.state == 1) {
            this.performInitialStringSubstitution(true);
        }
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        String text = this.text;
        text = this.searchResourceVar(text, true);
        text = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text, true);
        for (Map.Entry<String, String> entry : this.locationVariables.entrySet()) {
            String value = locationProcessor != null ? locationProcessor.process(entry.getValue()) : entry.getValue();
            text = text.replace(entry.getKey(), value);
        }
        this.text = text;
        this.state = 3;
    }

    public static interface LocationProcessor {
        public String process(String var1) throws CoreException;
    }
}

