/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.TexEditorTools;

public class HardLineWrap {
    private static final Pattern simpleCommandPattern = Pattern.compile("\\\\(\\w+|\\\\)\\s*(\\[.*?\\]\\s*)*(\\{.*?\\}\\s*)*");

    private static String trimBegin(String str) {
        int i = 0;
        while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        return str.substring(i);
    }

    private static String trimBeginPlusComment(String str) {
        int i = 0;
        while (i < str.length() && Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        if (i < str.length() && str.charAt(i) == '%') {
            ++i;
        }
        if (i < str.length() && str.charAt(i) == ' ') {
            ++i;
        }
        return str.substring(i);
    }

    private static String trimEnd(String str) {
        int i = str.length() - 1;
        while (i >= 0 && Character.isWhitespace(str.charAt(i))) {
            --i;
        }
        return str.substring(0, i + 1);
    }

    private static boolean isSingleLine(String line) {
        if (line.isEmpty() || line.startsWith("%") || line.startsWith("\\") && line.length() == 2 || line.startsWith("\\item")) {
            return true;
        }
        Matcher m = simpleCommandPattern.matcher(line);
        return m.matches();
    }

    private static int getLineBreakPosition(String line, int MAX_LENGTH) {
        int offset = 0;
        while (offset < line.length() && (line.charAt(offset) == ' ' || line.charAt(offset) == '\t')) {
            ++offset;
        }
        int breakOffset = -1;
        while (offset < line.length()) {
            if (offset > MAX_LENGTH && breakOffset != -1) break;
            if (line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
                breakOffset = offset;
            }
            ++offset;
        }
        return breakOffset;
    }

    public void doWrapB(IDocument d, DocumentCommand c, int MAX_LENGTH) {
        try {
            String newLine;
            int breakpos;
            IRegion commandRegion = d.getLineInformationOfOffset(c.offset);
            if (commandRegion.getLength() + c.text.length() <= MAX_LENGTH || c.text.indexOf("\n") >= 0 || c.text.indexOf("\r") >= 0) {
                return;
            }
            String line = d.get(commandRegion.getOffset(), commandRegion.getLength());
            int lineNr = d.getLineOfOffset(c.offset);
            int cursorOnLine = c.offset - commandRegion.getOffset();
            StringBuffer newLineBuf = new StringBuffer();
            newLineBuf.append(line.substring(0, cursorOnLine));
            newLineBuf.append(c.text);
            newLineBuf.append(HardLineWrap.trimEnd(line.substring(cursorOnLine)));
            if (HardLineWrap.trimEnd(newLineBuf.toString()).length() <= MAX_LENGTH) {
                return;
            }
            String delim = d.getLineDelimiter(lineNr);
            boolean isLastLine = false;
            if (delim == null) {
                isLastLine = true;
                if (lineNr > 0) {
                    delim = d.getLineDelimiter(lineNr - 1);
                } else {
                    String[] delims = d.getLegalLineDelimiters();
                    delim = delims[0];
                }
            }
            String indent = TexEditorTools.getIndentationWithComment(line);
            int length = line.length();
            String nextline = TexEditorTools.getStringAt(d, c, false, 1);
            String nextTrimLine = nextline.trim();
            boolean isWithNextline = false;
            if (line.trim().endsWith(".") || line.trim().endsWith(":") || line.trim().endsWith("\\\\")) {
                newLineBuf.append(delim);
            } else if (TexEditorTools.getIndexOfComment(line) >= 0 && TexEditorTools.isLineCommentLine(nextTrimLine) && TexEditorTools.getIndentation(line).equals(TexEditorTools.getIndentation(nextline)) && !HardLineWrap.isSingleLine(HardLineWrap.trimBeginPlusComment(nextTrimLine))) {
                newLineBuf.append(' ');
                newLineBuf.append(HardLineWrap.trimBeginPlusComment(nextline));
                length += nextline.length();
                isWithNextline = true;
            } else if (TexEditorTools.getIndexOfComment(line) >= 0) {
                newLineBuf.append(delim);
            } else if (HardLineWrap.isSingleLine(nextTrimLine)) {
                newLineBuf.append(delim);
            } else {
                newLineBuf.append(' ');
                newLineBuf.append(HardLineWrap.trimBegin(nextline));
                length += nextline.length();
                isWithNextline = true;
            }
            if (!isLastLine) {
                length += delim.length();
            }
            if ((breakpos = HardLineWrap.getLineBreakPosition(newLine = newLineBuf.toString(), MAX_LENGTH)) < 0) {
                return;
            }
            c.length = length;
            c.shiftsCaret = false;
            c.caretOffset = c.offset + c.text.length() + indent.length();
            if (breakpos >= cursorOnLine + c.text.length()) {
                c.caretOffset -= indent.length();
            }
            if (breakpos < cursorOnLine + c.text.length()) {
                c.caretOffset += delim.length() - 1;
            }
            c.offset = commandRegion.getOffset();
            StringBuffer buf = new StringBuffer();
            buf.append(newLine.substring(0, breakpos));
            buf.append(delim);
            buf.append(indent);
            if (TexEditorTools.getIndexOfComment(newLine.substring(0, breakpos)) >= 0 && TexEditorTools.getIndexOfComment(indent) == -1) {
                buf.append("% ");
            }
            buf.append(HardLineWrap.trimBegin(newLine.substring(breakpos)));
            int i = 0;
            while (i < line.length() && line.charAt(i) == buf.charAt(i)) {
                ++i;
            }
            buf.delete(0, i);
            c.offset += i;
            c.length -= i;
            if (isWithNextline) {
                i = 0;
                while (i < nextline.length() && nextline.charAt(nextline.length() - i - 1) == buf.charAt(buf.length() - i - 1)) {
                    ++i;
                }
                buf.delete(buf.length() - i, buf.length());
                c.length -= i;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            TexEditorTools.log("BasicProblem with hard line wrap", e);
        }
    }
}

