/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui.editors;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.swt.graphics.Point;

public class TexMarkOccurrencesLocator {
    public void run(AbstractMarkOccurrencesProvider.RunData run, SourceUnitModelInfo info, AstSelection astSelection, @Nullable ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
        TexAstNode node = (TexAstNode)astSelection.getCovering();
        if (this.checkForAccess(run, node)) {
            return;
        }
    }

    private boolean checkForAccess(AbstractMarkOccurrencesProvider.RunData run, TexAstNode node) throws BadLocationException {
        if (node == null || node.getNodeType() != NodeType.LABEL) {
            return false;
        }
        do {
            for (Object attachment : node.getAttachments()) {
                TexNameAccess access;
                Map<Annotation, Position> annotations;
                if (!(attachment instanceof TexNameAccess) || (annotations = this.checkDefault(run, access = (TexNameAccess)attachment)) == null) continue;
                run.set(annotations);
                return true;
            }
        } while ((node = node.getTexParent()) != null);
        return false;
    }

    private Map<Annotation, Position> checkDefault(AbstractMarkOccurrencesProvider.RunData run, TexNameAccess access) throws BadLocationException {
        while (access != null) {
            TexAstNode nameNode = (TexAstNode)access.getNameNode();
            if (nameNode == null) {
                return null;
            }
            if (run.accept(new Point(nameNode.getStartOffset(), nameNode.getEndOffset()))) {
                ImList accessList = access.getAllInUnit();
                LinkedHashMap<Annotation, Position> annotations = new LinkedHashMap<Annotation, Position>(accessList.size());
                for (TexNameAccess occurrence : accessList) {
                    String message = run.doc.get(((TexAstNode)occurrence.getNode()).getStartOffset(), ((TexAstNode)occurrence.getNode()).getLength());
                    annotations.put(new Annotation(occurrence.isWriteAccess() ? "org.eclipse.statet.ecommons.text.editorAnnotations.WriteOccurrences" : "org.eclipse.statet.ecommons.text.editorAnnotations.CommonOccurrences", false, message), TexNameAccess.getTextPosition((TexAstNode)((TexAstNode)occurrence.getNameNode())));
                }
                return annotations;
            }
            access = null;
        }
        return null;
    }
}

