/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.util.UnterminatedLaunchAlerter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.jcommons.runtime.ProcessUtils;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolRunner;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleColorAdapter;
import org.eclipse.statet.nico.ui.util.WorkbenchStatusHandler;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.ui.RConsole;
import org.eclipse.statet.r.console.ui.launching.RConsoleLaunching;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.statet.r.nico.impl.RTermController;
import org.eclipse.ui.IWorkbenchPage;

public class RConsoleRTermLaunchDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Charset charset;
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)false);
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        long timestamp = System.currentTimeMillis();
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        IREnvConfiguration renv = RLaunching.getREnvConfig((ILaunchConfiguration)configuration, (boolean)true);
        IFileStore workingDirectory = REnvTab.getWorkingDirectory((ILaunchConfiguration)configuration);
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(workingDirectory.toLocalFile(0, null));
        Map<String, String> envp = builder.environment();
        LaunchUtils.configureEnvironment(envp, (ILaunchConfiguration)configuration, (Map)renv.getEnvironmentsVariables());
        List<String> cmdLine = builder.command();
        cmdLine.addAll(0, renv.getExecCommand(IREnvConfiguration.Exec.TERM));
        if (Platform.getOS().startsWith("win")) {
            cmdLine.add("--ess");
        } else {
            cmdLine.add("--interactive");
        }
        cmdLine.addAll(Arrays.asList(LaunchUtils.getProcessArguments((ILaunchConfiguration)configuration, (String)"org.eclipse.statet.r.debug/RConsole/arguments.options")));
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        String encoding = configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "");
        try {
            charset = encoding.length() > 0 ? Charset.forName(encoding) : Charset.defaultCharset();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, NLS.bind((String)Messages.LaunchDelegate_error_InvalidUnsupportedConsoleEncoding_message, (Object)encoding), (Throwable)e));
        }
        m.worked(1);
        if (m.isCanceled()) {
            return;
        }
        UnterminatedLaunchAlerter.registerLaunchType((String)"org.eclipse.statet.r.launchConfigurations.RConsole");
        RProcess process = new RProcess(launch, renv, LaunchUtils.createLaunchPrefix((ILaunchConfiguration)configuration), String.valueOf(renv.getName()) + " / Rterm " + LaunchUtils.createProcessTimestamp((long)timestamp), null, workingDirectory.toString(), timestamp);
        process.setAttribute(IProcess.ATTR_CMDLINE, ProcessUtils.generateCommandLine(cmdLine));
        RTermController controller = new RTermController(process, builder, charset);
        process.init((ToolController)controller);
        RConsoleLaunching.registerDefaultHandlerTo((AbstractRController)controller);
        m.worked(5);
        RConsoleLaunching.scheduleStartupSnippet((AbstractRController)controller, configuration);
        RConsole console = new RConsole(process, new NIConsoleColorAdapter());
        NicoUITools.startConsoleLazy((NIConsole)console, (IWorkbenchPage)page, (boolean)configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/console.pin", false));
        new ToolRunner().runInBackgroundThread((ToolProcess)process, (IStatusHandler)new WorkbenchStatusHandler());
        if (monitor != null) {
            monitor.done();
        }
    }
}

