/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import java.util.Map;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.ClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.CompositeLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.layer.cell.AggregrateConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.layer.cell.CellLabelContributor;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

@NonNullByDefault
public class CompositeLayer
extends AbstractLayer<CompositeLayerDim> {
    protected final int layoutXCount;
    protected final int layoutYCount;
    private final @NonNull Child[] @NonNull [] childLayout;

    public CompositeLayer(int layoutXCount, int layoutYCount) {
        this.layoutXCount = layoutXCount;
        this.layoutYCount = layoutYCount;
        this.childLayout = new Child[layoutXCount][layoutYCount];
        this.init();
    }

    @Override
    protected CompositeLayerDim createDim(Orientation orientation) {
        return this.ignoreRef(orientation) ? new CompositeLayerDim.IgnoreRef(this, orientation) : new CompositeLayerDim(this, orientation);
    }

    protected boolean ignoreRef(Orientation orientation) {
        return false;
    }

    @Override
    protected LayerPainter createPainter() {
        return new CompositeLayerPainter(this);
    }

    @Override
    public void dispose() {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                Child child = this.childLayout[layoutX][layoutY];
                if (child != null) {
                    child.layer.dispose();
                }
                ++layoutY;
            }
            ++layoutX;
        }
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                Child child = this.childLayout[layoutX][layoutY];
                if (child != null) {
                    child.layer.saveState(String.valueOf(prefix) + "." + child.label, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                Child child = this.childLayout[layoutX][layoutY];
                if (child != null) {
                    child.layer.loadState(String.valueOf(prefix) + "." + child.label, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                this.childLayout[layoutX][layoutY].layer.configure(configRegistry, uiBindingRegistry);
                ++layoutY;
            }
            ++layoutX;
        }
        super.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        return this.doCommandOnChildLayers(command);
    }

    protected boolean doCommandOnChildLayers(LayerCommand command) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (this.childLayout[layoutX][layoutY].layer.doCommand(command)) {
                    return true;
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return false;
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        final Child child = this.getChildByPosition(columnPosition, rowPosition);
        if (child == null) {
            throw new PositionOutOfBoundsException(String.valueOf(columnPosition) + ", " + rowPosition);
        }
        final long childColumnPosition = columnPosition - ((CompositeLayerDim)this.getDim(Orientation.HORIZONTAL)).getLayoutPosition(child.layoutX);
        final long childRowPosition = rowPosition - ((CompositeLayerDim)this.getDim(Orientation.VERTICAL)).getLayoutPosition(child.layoutY);
        LayerCell underlyingCell = child.layer.getCellByPosition(childColumnPosition, childRowPosition);
        LayerCellDim hDim = this.transformCellDim(underlyingCell.getDim(Orientation.HORIZONTAL), columnPosition);
        LayerCellDim vDim = this.transformCellDim(underlyingCell.getDim(Orientation.VERTICAL), rowPosition);
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public LabelStack getLabels() {
                LabelStack configLabels = super.getLabels();
                if (child.configLabelAccumulator != null) {
                    child.configLabelAccumulator.addLabels(configLabels, childColumnPosition, childRowPosition);
                }
                configLabels.addLabel(child.label);
                return configLabels;
            }
        };
    }

    protected LayerCellDim transformCellDim(LayerCellDim underlyingDim, long position) {
        long originPosition = underlyingDim.getPosition() == underlyingDim.getOriginPosition() ? position : ((CompositeLayerDim)this.getDim(underlyingDim.getOrientation())).underlyingToLocalPosition(position, underlyingDim.getOriginPosition());
        return new BasicLayerCellDim(underlyingDim.getOrientation(), underlyingDim.getId(), position, originPosition, underlyingDim.getPositionSpan());
    }

    public void setChildLayer(String label, Layer childLayer, int layoutX, int layoutY) {
        final Child child = new Child(layoutX, layoutY, label, (Layer)ObjectUtils.nonNullAssert((Object)childLayer));
        childLayer.addLayerListener(this);
        this.childLayout[layoutX][layoutY] = child;
        ((CompositeLayerDim)this.getDim(Orientation.HORIZONTAL)).setChild(layoutX, layoutY, childLayer);
        ((CompositeLayerDim)this.getDim(Orientation.VERTICAL)).setChild(layoutY, layoutX, childLayer);
        childLayer.setClientAreaProvider(new ClientAreaProvider(){

            @Override
            public LRectangle getClientArea() {
                return CompositeLayer.this.getChildClientArea(child);
            }
        });
    }

    public void addCellLabelContributor(String regionLabel, CellLabelContributor labelContributor) {
        Child child = this.getChildByLabel(regionLabel);
        if (child.configLabelAccumulator == null) {
            child.configLabelAccumulator = labelContributor;
        } else {
            AggregrateConfigLabelAccumulator aggregateAccumulator;
            if (child.configLabelAccumulator instanceof AggregrateConfigLabelAccumulator) {
                aggregateAccumulator = (AggregrateConfigLabelAccumulator)child.configLabelAccumulator;
            } else {
                aggregateAccumulator = new AggregrateConfigLabelAccumulator();
                aggregateAccumulator.add(child.configLabelAccumulator);
                child.configLabelAccumulator = aggregateAccumulator;
            }
            aggregateAccumulator.add(labelContributor);
        }
    }

    private LRectangle getChildClientArea(Child child) {
        LRectangle compositeClientArea = this.getClientAreaProvider().getClientArea();
        LRectangle childClientArea = new LRectangle(compositeClientArea.x + ((CompositeLayerDim)this.getDim(Orientation.HORIZONTAL)).getLayoutStart(child.layoutX), compositeClientArea.y + ((CompositeLayerDim)this.getDim(Orientation.VERTICAL)).getLayoutStart(child.layoutY), child.layer.getDim(Orientation.HORIZONTAL).getPreferredSize(), child.layer.getDim(Orientation.VERTICAL).getPreferredSize());
        LRectangle intersection = compositeClientArea.intersection(childClientArea);
        return intersection;
    }

    public @Nullable Layer getChildLayerByLayoutCoordinate(int layoutX, int layoutY) {
        if (layoutX < 0 || layoutX >= this.layoutXCount || layoutY < 0 || layoutY >= this.layoutYCount) {
            return null;
        }
        return this.childLayout[layoutX][layoutY].layer;
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        Child child = this.getChildByPixelXY(x, y);
        if (child == null) {
            return null;
        }
        long childX = x - ((CompositeLayerDim)this.getDim(Orientation.HORIZONTAL)).getLayoutStart(child.layoutX);
        long childY = y - ((CompositeLayerDim)this.getDim(Orientation.VERTICAL)).getLayoutStart(child.layoutY);
        LabelStack regionLabels = child.layer.getRegionLabelsByXY(childX, childY);
        regionLabels.addLabel(child.label);
        return regionLabels;
    }

    @Override
    public @Nullable Layer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        Child child = this.getChildByPosition(columnPosition, rowPosition);
        return child != null ? child.layer : null;
    }

    protected final @Nullable Child getChildByLabel(String label) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (label.equals(this.childLayout[layoutX][layoutY].label)) {
                    return this.childLayout[layoutX][layoutY];
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return null;
    }

    protected final @Nullable Child getChildByLayer(Layer childLayer) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (this.childLayout[layoutX][layoutY].layer == childLayer) {
                    return this.childLayout[layoutX][layoutY];
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return null;
    }

    protected final @Nullable Child getChildByPixelXY(long x, long y) {
        int layoutX = ((CompositeLayerDim)this.getDim(Orientation.HORIZONTAL)).getLayoutByPixel(x);
        if (layoutX < 0) {
            return null;
        }
        int layoutY = ((CompositeLayerDim)this.getDim(Orientation.VERTICAL)).getLayoutByPixel(y);
        if (layoutY < 0) {
            return null;
        }
        return this.childLayout[layoutX][layoutY];
    }

    protected final @Nullable Child getChildByPosition(long compositeColumnPosition, long compositeRowPosition) {
        int layoutX = ((CompositeLayerDim)this.getDim(Orientation.HORIZONTAL)).getLayoutByPosition(compositeColumnPosition);
        if (layoutX < 0) {
            return null;
        }
        int layoutY = ((CompositeLayerDim)this.getDim(Orientation.VERTICAL)).getLayoutByPosition(compositeRowPosition);
        if (layoutY < 0) {
            return null;
        }
        return this.childLayout[layoutX][layoutY];
    }

    protected static final class Child {
        public final int layoutX;
        public final int layoutY;
        public final String label;
        public final Layer layer;
        private CellLabelContributor configLabelAccumulator;

        private Child(int x, int y, String label, Layer layer) {
            this.layoutX = x;
            this.layoutY = y;
            this.label = label;
            this.layer = layer;
        }
    }

    public static class CompositeLayerPainter
    implements LayerPainter {
        protected final CompositeLayer layer;

        public CompositeLayerPainter(CompositeLayer layer) {
            this.layer = layer;
        }

        @Override
        public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle cellBounds) {
            Child child = this.layer.getChildByPosition(columnPosition, rowPosition);
            CompositeLayerDim hDim = (CompositeLayerDim)this.layer.getDim(Orientation.HORIZONTAL);
            CompositeLayerDim vDim = (CompositeLayerDim)this.layer.getDim(Orientation.VERTICAL);
            long widthOffset = hDim.getLayoutStart(child.layoutX);
            long heightOffset = vDim.getLayoutStart(child.layoutY);
            cellBounds.x -= widthOffset;
            cellBounds.y -= heightOffset;
            LayerPainter childLayerPainter = child.layer.getLayerPainter();
            long childColumnPosition = columnPosition - hDim.getLayoutPosition(child.layoutX);
            long childRowPosition = rowPosition - vDim.getLayoutPosition(child.layoutY);
            LRectangle adjustedChildCellBounds = childLayerPainter.adjustCellBounds(childColumnPosition, childRowPosition, cellBounds);
            adjustedChildCellBounds.x += widthOffset;
            adjustedChildCellBounds.y += heightOffset;
            return adjustedChildCellBounds;
        }

        @Override
        public void paintLayer(Layer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, ConfigRegistry configuration) {
            int x = xOffset;
            int layoutX = 0;
            while (layoutX < this.layer.layoutXCount) {
                int y = yOffset;
                Child[] layoutXChilds = this.layer.childLayout[layoutX];
                int width = GraphicsUtils.safe(layoutXChilds[0].layer.getWidth());
                int layoutY = 0;
                while (layoutY < this.layer.layoutYCount) {
                    Child child = layoutXChilds[layoutY];
                    int height = GraphicsUtils.safe(child.layer.getHeight());
                    Rectangle childRectangle = new Rectangle(x, y, width, height);
                    Rectangle childPaintRectangle = pixelRectangle.intersection(childRectangle);
                    if (!childPaintRectangle.isEmpty()) {
                        Rectangle originalClipping = gc.getClipping();
                        gc.setClipping(childPaintRectangle);
                        LayerPainter layerPainter = child.layer.getLayerPainter();
                        layerPainter.paintLayer(natLayer, gc, x, y, childPaintRectangle, configuration);
                        gc.setClipping(originalClipping);
                    }
                    y += height;
                    ++layoutY;
                }
                x += width;
                ++layoutX;
            }
        }
    }
}

