/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.config;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCodeStyleSettings;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.text.ui.settings.IndentSettingsUI;
import org.eclipse.statet.ecommons.ui.CombineStatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class WikitextCodeStylePreferenceBlock
extends ManagedConfigurationBlock {
    private WikitextCodeStyleSettings model;
    private IndentSettingsUI stdIndentSettings;
    private final CombineStatusChangeListener statusListener;

    public WikitextCodeStylePreferenceBlock(IProject project, StatusChangeListener statusListener) {
        super(project);
        this.statusListener = new CombineStatusChangeListener(statusListener);
        this.setStatusListener((StatusChangeListener)this.statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, String> prefs = new HashMap<Object, String>();
        prefs.put(WikitextCodeStyleSettings.TAB_SIZE_PREF, "Wikitext/Wikitext.codestyle/indent");
        prefs.put(WikitextCodeStyleSettings.INDENT_DEFAULT_TYPE_PREF, "Wikitext/Wikitext.codestyle/indent");
        prefs.put(WikitextCodeStyleSettings.INDENT_SPACES_COUNT_PREF, "Wikitext/Wikitext.codestyle/indent");
        prefs.put(WikitextCodeStyleSettings.REPLACE_CONVERSATIVE_PREF, "Wikitext/Wikitext.codestyle/indent");
        prefs.put(WikitextCodeStyleSettings.REPLACE_TABS_WITH_SPACES_PREF, "Wikitext/Wikitext.codestyle/indent");
        this.setupPreferenceManager(prefs);
        this.model = new WikitextCodeStyleSettings(0);
        this.stdIndentSettings = new IndentSettingsUI();
        Composite mainComposite = new Composite(pageComposite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        TabFolder folder = new TabFolder(mainComposite, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabItem item = new TabItem(folder, 0);
        item.setText(this.stdIndentSettings.getGroupLabel());
        item.setControl(this.createIndentControls((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("&Line Wrapping");
        item.setControl(this.createLineControls((Composite)folder));
        this.initBindings();
        this.updateControls();
    }

    private Control createIndentControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.stdIndentSettings.createControls(composite);
        this.stdIndentSettings.getTabSizeControl().setEditable(false);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Composite depthComposite = new Composite(composite, 0);
        depthComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        depthComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)4));
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        return composite;
    }

    private Control createLineControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.stdIndentSettings.addLineWidth(composite);
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        this.stdIndentSettings.addBindings(db, (Object)this.model);
    }

    protected void updateControls() {
        this.model.load((PreferenceAccess)this);
        this.model.resetDirty();
        this.getDataBinding().getContext().updateTargets();
    }

    protected void updatePreferences() {
        if (this.model.isDirty()) {
            this.model.resetDirty();
            this.setPrefValues(this.model.toPreferencesMap());
        }
    }
}

