/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.text.core.util.ImmutableDocument;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.input.BasicSourceFragment;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public class RRuntimeSourceFragment
extends BasicSourceFragment {
    private final RProcess process;

    private static String createId(RProcess process, String name, String fullName, String source) {
        return "r:" + process.getLabel(0) + '-' + process.getStartupTimestamp() + '/' + fullName + '-' + source.hashCode();
    }

    public RRuntimeSourceFragment(RProcess process, String name, String fullName, String source) {
        super(RRuntimeSourceFragment.createId(process, name, fullName, source), name, fullName, (AbstractDocument)new ImmutableDocument(source, System.currentTimeMillis()));
        this.process = process;
    }

    public RProcess getProcess() {
        return this.process;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == ToolProcess.class) {
            return (T)this.process;
        }
        if (adapterType == REnv.class) {
            return (T)this.process.getAdapter(REnv.class);
        }
        return null;
    }
}

