/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import org.eclipse.core.expressions.AndExpression;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;

@NonNullByDefault
public class ControlServicesUtil {
    private final String id;
    private final IServiceLocator serviceLocator;
    private final Expression defaultExpression;
    private boolean requireDeactivation;

    public ControlServicesUtil(IServiceLocator serviceLocator, String id, Control parentControl) {
        assert (serviceLocator != null);
        assert (id != null);
        assert (parentControl != null);
        this.id = id;
        this.serviceLocator = serviceLocator;
        this.defaultExpression = this.initExpression(parentControl);
    }

    private Expression initExpression(Control control) {
        FocusExpression focusExpression = new FocusExpression();
        if (this.serviceLocator instanceof IWorkbench) {
            AndExpression and = new AndExpression();
            and.add((Expression)new ActiveShellExpression(control.getShell()));
            and.add((Expression)focusExpression);
            this.requireDeactivation = true;
            return and;
        }
        if (this.serviceLocator instanceof IWorkbenchWindow && !control.getShell().equals(((IWorkbenchWindow)this.serviceLocator).getShell())) {
            AndExpression and = new AndExpression();
            and.add((Expression)new ActiveShellExpression(control.getShell()));
            and.add((Expression)focusExpression);
            this.requireDeactivation = true;
            return and;
        }
        this.requireDeactivation = false;
        return focusExpression;
    }

    public void addControl(Control control) {
        IFocusService focusService = (IFocusService)ObjectUtils.nonNullAssert((Object)((IFocusService)this.serviceLocator.getService(IFocusService.class)));
        focusService.addFocusTracker(control, this.id);
    }

    public Expression getExpression() {
        return this.defaultExpression;
    }

    public boolean getRequireDeactivation() {
        return this.requireDeactivation;
    }

    private class FocusExpression
    extends Expression {
        private FocusExpression() {
        }

        String getFocusControlId() {
            return ControlServicesUtil.this.id;
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            Object id = context.getVariable("activeFocusControlId");
            return EvaluationResult.valueOf((ControlServicesUtil.this.id == id ? 1 : 0) != 0);
        }

        public void collectExpressionInfo(ExpressionInfo info) {
            info.addVariableNameAccess("activeFocusControlId");
        }

        protected int computeHashCode() {
            return FocusExpression.class.hashCode() * 89 + FocusExpression.hashCode((Object)ControlServicesUtil.this.id) * 89;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FocusExpression) {
                FocusExpression other = (FocusExpression)((Object)obj);
                return ControlServicesUtil.this.id.equals(other.getFocusControlId());
            }
            return false;
        }
    }
}

