/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.internal.ltk.ui.refactoring.TextEditAnnotator;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.QuickRefactoring;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CommandAssistProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class QuickRefactoringAssistProposal<TContext extends AssistInvocationContext>
extends CommandAssistProposal<TContext> {
    private final QuickRefactoring refactoring;

    public QuickRefactoringAssistProposal(CommandAssistProposal.ProposalParameters<TContext> parameters, QuickRefactoring refactoring) {
        super(parameters);
        this.refactoring = refactoring;
        this.check();
    }

    public QuickRefactoringAssistProposal(TContext invocationContext, String commandId, String label, QuickRefactoring refactoring) {
        super(invocationContext, commandId, label, null);
        this.refactoring = refactoring;
        this.check();
    }

    protected void check() {
        if (((AssistInvocationContext)this.getInvocationContext()).getSourceUnit() == null) {
            throw new IllegalArgumentException();
        }
    }

    protected QuickRefactoring getRefactoring() {
        return this.refactoring;
    }

    @Override
    public @Nullable Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        try {
            StringBuilder sb = new StringBuilder();
            TextChange change = this.refactoring.createTextChange(m.newChild(2));
            change.setKeepPreviewEdits(true);
            IDocument previewDocument = change.getPreviewDocument((IProgressMonitor)m.newChild(1));
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            TextEditAnnotator ea = new TextEditAnnotator(sb, previewDocument);
            rootEdit.accept((TextEditVisitor)ea);
            m.worked(1);
            DefaultBrowserInformationInput defaultBrowserInformationInput = new DefaultBrowserInformationInput(this.getDisplayString(), sb.toString(), 4, ((AssistInvocationContext)this.getInvocationContext()).getTabSize());
            return defaultBrowserInformationInput;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, String.format("An error occured when generating the preview for quick assist '%1$s'.", this.getDisplayString()), (Throwable)e));
            return null;
        }
        finally {
            m.done();
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        Object context = this.getInvocationContext();
        @NonNull SourceUnit sourceUnit = ((AssistInvocationContext)context).getSourceUnit();
        SourceEditor editor = ((AssistInvocationContext)context).getEditor();
        StyledText textWidget = editor.getViewer().getTextWidget();
        if (textWidget == null) {
            return;
        }
        IProgressService execContext = null;
        IServiceLocator serviceLocator = editor.getServiceLocator();
        if (serviceLocator != null) {
            execContext = (IProgressService)serviceLocator.getService(IProgressService.class);
        }
        if (execContext == null) {
            return;
        }
        CommandAssistProposal.ApplyData applyData = this.getApplyData();
        try {
            QuickRefactoring refactoring = this.refactoring;
            RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)refactoring, offset, textWidget.getShell(), execContext);
            helper.enableInsertPosition(sourceUnit);
            helper.perform(false, false);
            Position position = helper.getInsertPosition();
            if (position != null) {
                applyData.setSelection(position.getOffset());
            }
        }
        catch (InterruptedException refactoring) {
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, String.format("An error occured when executing quick assist '%1$s'.", this.getDisplayString()), (Throwable)e));
        }
    }
}

