/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class FunctionToS4MethodRefactoring
extends Refactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private TextRegion selectionRegion;
    private TextRegion operationRegion;
    private final RSourceUnit sourceUnit;
    private RLangMethod function;
    private List<Variable> variablesList;
    private String functionName = "";
    private boolean generateGeneric = true;

    public FunctionToS4MethodRefactoring(RSourceUnit su, TextRegion selection) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        if (selection != null && selection.getStartOffset() >= 0 && selection.getLength() >= 0) {
            this.selectionRegion = selection;
        }
    }

    public String getName() {
        return Messages.FunctionToS4Method_label;
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.ExtractFunctionOperation";
    }

    public void setFunctionName(String newName) {
        this.functionName = newName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Variable> getVariables() {
        return this.variablesList;
    }

    public void setGenerateGeneric(boolean enable) {
        this.generateGeneric = enable;
    }

    public boolean getGenerateGeneric() {
        return this.generateGeneric;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            if (this.selectionRegion != null) {
                this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
                try {
                    AbstractDocument document = this.sourceUnit.getDocument(monitor);
                    RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
                    RSourceUnitModelInfo modelInfo = (RSourceUnitModelInfo)this.sourceUnit.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
                    if (modelInfo != null) {
                        TextRegion region = this.adapter.trimToAstRegion(document, this.selectionRegion, scanner);
                        SourceStructElement element = LtkModelUtils.getCoveringSourceElement((SourceStructElement)modelInfo.getSourceElement(), (TextRegion)region);
                        while (element != null) {
                            if (element instanceof RLangMethod) {
                                this.function = (RLangMethod)element;
                                break;
                            }
                            element = element.getSourceParent();
                        }
                    }
                    if (this.function != null) {
                        SourceStructElement source = (SourceStructElement)this.function;
                        this.operationRegion = this.adapter.expandSelectionRegion(document, source.getSourceRange(), this.selectionRegion, scanner);
                    }
                }
                finally {
                    this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
                }
            }
            if (this.function == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.FunctionToS4Method_error_InvalidSelection_message);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            m.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.checkFunction(result);
            m.worked(2);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    private void checkFunction(RefactoringStatus result) {
        if ((this.function.getElementType() & 0xFF0) != 1296 && (this.function.getElementType() & 0xFF0) != 1296) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.FunctionToS4Method_error_SelectionAlreadyS4_message));
            return;
        }
        RAstNode node = (RAstNode)((Object)this.function.getAdapter(AstNode.class));
        if (RAsts.hasErrors((AstNode)node)) {
            result.merge(RefactoringStatus.createWarningStatus((String)Messages.FunctionToS4Method_warning_SelectionSyntaxError_message));
        }
        RElementName elementName = this.function.getElementName().getLastSegment();
        this.functionName = elementName.getDisplayName();
        Parameters parameters = this.function.getParameters();
        int count = parameters != null ? parameters.size() : 0;
        this.variablesList = new ArrayList<Variable>(count);
        boolean dots = false;
        int i = 0;
        while (i < count) {
            Parameters.Parameter parameter = parameters.get(i);
            Variable variable = new Variable(parameter);
            if (variable.getName().equals("...")) {
                dots = true;
                variable.init(true);
            } else {
                variable.init(!dots);
            }
            this.variablesList.add(variable);
            ++i;
        }
    }

    public RefactoringStatus checkFunctionName(String newName) {
        if (newName == null || newName.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)Messages.RIdentifiers_error_EmptyFor_message, (Object)"The function name"));
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = this.checkFunctionName(this.functionName);
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges((TextFileChange)textFileChange, m.newChild(2));
            HashMap arguments = new HashMap();
            String varName = RRefactoringAdapter.getUnquotedIdentifier(this.functionName);
            String description = NLS.bind((String)Messages.FunctionToS4Method_Descriptor_description, (Object)RUtil.formatVarName(varName));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, Messages.FunctionToS4Method_label, new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", "Unexpected error (concurrent change?)", (Throwable)e));
        }
        finally {
            m.done();
        }
    }

    private void createChanges(TextFileChange change, SubMonitor m) throws BadLocationException, CoreException {
        m.setWorkRemaining(15);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            RAstNode parent;
            AbstractDocument document = this.sourceUnit.getDocument((IProgressMonitor)m.newChild(1));
            RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
            RCodeStyleSettings codeStyle = RRefactoringAdapter.getCodeStyle(this.sourceUnit);
            StringBuilder sb = new StringBuilder();
            String nl = document.getDefaultLineDelimiter();
            String argAssign = codeStyle.getArgAssignString();
            RAstNode firstParentChild = (RAstNode)((Object)this.function.getAdapter(AstNode.class));
            while ((parent = firstParentChild.getRParent()) != null && parent.getNodeType() != NodeType.SOURCELINES && parent.getNodeType() != NodeType.BLOCK) {
                firstParentChild = parent;
            }
            TextRegion region = this.adapter.expandWhitespaceBlock(document, this.operationRegion, scanner);
            int insertOffset = this.adapter.expandWhitespaceBlock(document, this.adapter.expandSelectionRegion(document, (TextRegion)new BasicTextRegion(firstParentChild.getStartOffset()), this.operationRegion, scanner), scanner).getStartOffset();
            FDef fdefNode = (FDef)((Object)this.function.getAdapter(FDef.class));
            TextRegion fbodyRegion = this.adapter.expandWhitespaceBlock(document, this.adapter.expandSelectionRegion(document, (TextRegion)fdefNode.getContChild(), this.operationRegion, scanner), scanner);
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FunctionToS4Method_Changes_DeleteOld_name, (TextEdit)new DeleteEdit(region.getStartOffset(), region.getLength()));
            m.worked(4);
            sb.setLength(0);
            sb.append("setGeneric(\"");
            sb.append(this.functionName);
            sb.append("\",");
            sb.append(nl);
            sb.append("function(");
            boolean dots = false;
            for (Variable variable : this.variablesList) {
                if (variable.getName().equals("...")) {
                    dots = true;
                }
                if (!variable.getUseAsGenericArgument()) continue;
                sb.append(RElementName.create(17, variable.getName()).getDisplayName());
                sb.append(", ");
            }
            if (!dots) {
                sb.append("..., ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(')');
            if (codeStyle.getNewlineFDefBodyBlockBefore()) {
                sb.append(nl);
            } else {
                sb.append(' ');
            }
            sb.append('{');
            sb.append(nl);
            sb.append("standardGeneric(\"");
            sb.append(this.functionName);
            sb.append("\")");
            sb.append(nl);
            sb.append("})");
            sb.append(nl);
            sb.append(nl);
            String genericDef = RRefactoringAdapter.indent(sb, document, firstParentChild.getStartOffset(), this.sourceUnit, scanner);
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FunctionToS4Method_Changes_AddGenericDef_name, (TextEdit)new InsertEdit(insertOffset, genericDef));
            m.worked(4);
            sb.setLength(0);
            sb.append("setMethod(\"");
            sb.append(this.functionName);
            sb.append("\",");
            sb.append(nl);
            sb.append("signature(");
            boolean hasType = false;
            for (Variable variable : this.variablesList) {
                if (!variable.getUseAsGenericArgument() || variable.getArgumentType() == null) continue;
                hasType = true;
                sb.append(RElementName.create(17, variable.getName()).getDisplayName());
                sb.append(argAssign);
                sb.append("\"");
                sb.append(variable.getArgumentType());
                sb.append("\", ");
            }
            if (hasType) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append("),");
            sb.append(nl);
            sb.append("function(");
            FDef.Args argsNode = fdefNode.getArgsChild();
            for (Variable variable : this.variablesList) {
                sb.append(RElementName.create(17, variable.getName()).getDisplayName());
                FDef.Arg argNode = argsNode.getChild(variable.parameter.index);
                if (argNode.hasDefault()) {
                    sb.append(argAssign);
                    sb.append(document.get(argNode.getDefaultChild().getStartOffset(), argNode.getDefaultChild().getLength()));
                }
                sb.append(", ");
            }
            if (!this.variablesList.isEmpty()) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(')');
            if (codeStyle.getNewlineFDefBodyBlockBefore() || fdefNode.getContChild().getNodeType() != NodeType.BLOCK) {
                sb.append(nl);
            } else {
                sb.append(' ');
            }
            sb.append(document.get(fbodyRegion.getStartOffset(), fbodyRegion.getLength()).trim());
            sb.append(")");
            sb.append(nl);
            String methodDef = RRefactoringAdapter.indent(sb, document, firstParentChild.getStartOffset(), this.sourceUnit, scanner);
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FunctionToS4Method_Changes_AddMethodDef_name, (TextEdit)new InsertEdit(insertOffset, methodDef));
            m.worked(4);
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    public class Variable {
        private final Parameters.Parameter parameter;
        private boolean asGenericArgument;
        private boolean asGenericArgumentDefault;
        private String argumentType;

        public Variable(Parameters.Parameter parameter) {
            this.parameter = parameter;
        }

        void init(boolean enable) {
            this.asGenericArgumentDefault = this.asGenericArgument = enable;
        }

        public String getName() {
            return (String)ObjectUtils.nonNullElse((Object)this.parameter.getName(), (Object)"");
        }

        public boolean getUseAsGenericArgumentDefault() {
            return this.asGenericArgumentDefault;
        }

        public boolean getUseAsGenericArgument() {
            return this.asGenericArgument;
        }

        public void setUseAsGenericArgument(boolean enable) {
            this.asGenericArgument = enable;
        }

        public String getArgumentType() {
            return this.argumentType;
        }

        public void setArgumentType(String typeName) {
            this.argumentType = typeName != null && typeName.trim().length() > 0 ? typeName : null;
        }
    }
}

