/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.rmodel.EmbeddedInlineElement;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;
import org.eclipse.statet.internal.r.core.rmodel.SourceAnalyzer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.string.CacheStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.BasicSourceModelStamp;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.rmodel.RChunkElement;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.rmodel.build.RIssueReporter;
import org.eclipse.statet.r.core.rmodel.build.RSourceUnitModelContainer;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.core.source.ast.RoxygenParser;
import org.eclipse.statet.r.core.source.ast.SourceComponent;

@NonNullByDefault
public class RReconciler {
    private static final boolean LOG_TIME = false;
    private final RModelManagerImpl rManager;
    protected boolean stop = false;
    private final Object raLock = new Object();
    private final StringFactory raAstStringCache = new CacheStringFactory(32);
    private final StringParserInput raInput = new StringParserInput(4096);
    private final RParser raRParser = new RParser(RSourceConfig.DEFAULT_CONFIG, 4, this.raAstStringCache);
    private final RoxygenParser raRoxygenParser = new RoxygenParser(this.raAstStringCache);
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmScopeAnalyzer = new SourceAnalyzer();
    private final Object riLock = new Object();
    private final RIssueReporter riReporter = new RIssueReporter();
    private @Nullable RProject project;
    private @Nullable MultiStatus statusCollector;

    public RReconciler(RModelManagerImpl manager) {
        this.rManager = manager;
    }

    public void init(RProject project, MultiStatus statusCollector) throws CoreException {
        this.project = (RProject)ObjectUtils.nonNullAssert((Object)project);
        this.statusCollector = statusCollector;
        TaskIssueConfig taskIssueConfig = TaskIssueConfig.getConfig((PreferenceAccess)project.getPrefs());
        this.riReporter.configure(taskIssueConfig);
    }

    void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable RSourceUnitModelInfo reconcile(RSourceUnitModelContainer adapter, int flags, IProgressMonitor monitor) {
        Data data;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        RSourceUnit su = (RSourceUnit)adapter.getSourceUnit();
        int type = su.getModelTypeId().equals("R") ? su.getElementType() : 0;
        Data data2 = data = type != 0 ? new Data(adapter, m) : null;
        if (data == null || !data.isOK()) {
            adapter.clear();
            return null;
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            this.updateAst(data, flags);
        }
        if (this.stop || m.isCanceled()) {
            throw new CancellationException();
        }
        if ((flags & 0xF) < 2) {
            return null;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || m.isCanceled()) {
                throw new CancellationException();
            }
            boolean updated = this.updateModel(data, flags);
            if (updated) {
                this.rManager.getEventJob().addUpdate((LtkModelElement)data.sourceUnit, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            object = this.riLock;
            synchronized (object) {
                block18: {
                    if (!this.stop && !m.isCanceled() && data.newModel == data.adapter.getCurrentModel()) break block18;
                    return null;
                }
                this.reportIssues(data, flags);
            }
        }
        return data.newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSourceUnitModelInfo reconcile(RSourceUnit su, SourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunkElements, List<? extends SourceComponent> inlineNodes, int level, IProgressMonitor monitor) {
        Object object = this.rmLock;
        synchronized (object) {
            return this.updateModel(su, modelInfo, chunkElements, inlineNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, int flags) {
        RSourceConfig rSourceConfig = ((RSourceUnit)data.adapter.getSourceUnit()).getRCoreAccess().getRSourceConfig();
        BasicSourceModelStamp stamp = new BasicSourceModelStamp(data.content.getStamp(), ImCollections.newList((Object)rSourceConfig));
        AstInfo ast = data.adapter.getCurrentAst();
        if (ast != null && !stamp.equals((Object)ast.getStamp())) {
            ast = null;
        }
        if (ast != null) {
            data.ast = ast;
        } else {
            long startAst = System.nanoTime();
            Object input = data.content.getStartOffset() != 0 ? new OffsetStringParserInput(data.content.getString(), data.content.getStartOffset()) : this.raInput.reset(data.content.getString());
            this.raRParser.setRSourceConfig(rSourceConfig);
            this.raRParser.setCommentLevel(9);
            SourceComponent sourceComponent = this.raRParser.parseSourceFragment(input.init(data.content.getStartOffset(), data.content.getEndOffset()), null);
            ast = new AstInfo(this.raRParser.getAstLevel(), (SourceModelStamp)stamp, (AstNode)sourceComponent);
            long stopAst = System.nanoTime();
            this.raRoxygenParser.init(input.init(data.content.getStartOffset(), data.content.getEndOffset()));
            this.raRoxygenParser.update(sourceComponent);
            RSourceUnitModelContainer rSourceUnitModelContainer = data.adapter;
            synchronized (rSourceUnitModelContainer) {
                data.adapter.setAst(ast);
            }
            data.ast = ast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data, int flags) {
        RSourceUnitModelInfo model = (RSourceUnitModelInfo)data.adapter.getCurrentModel();
        if (model != null && !data.getAst().getStamp().equals(model.getStamp())) {
            model = null;
        }
        if (model != null) {
            data.newModel = model;
            return false;
        }
        long startModel = System.nanoTime();
        model = this.rmScopeAnalyzer.createModel((RSourceUnit)data.adapter.getSourceUnit(), data.getAst());
        boolean isOK = model != null;
        long stopModel = System.nanoTime();
        if (isOK) {
            RSourceUnitModelContainer rSourceUnitModelContainer = data.adapter;
            synchronized (rSourceUnitModelContainer) {
                data.oldModel = (RSourceUnitModelInfo)data.adapter.getCurrentModel();
                data.adapter.setModel(model);
            }
            data.newModel = model;
            return true;
        }
        return false;
    }

    private RSourceUnitModelInfo updateModel(RSourceUnit su, SourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunkElements, List<? extends SourceComponent> inlineNodes) {
        RSourceUnitModelInfo model;
        try {
            AstInfo ast = modelInfo.getAst();
            this.rmScopeAnalyzer.beginChunkSession(su, ast);
            for (RChunkElement rChunkElement : chunkElements) {
                Object rootNodes;
                SourceComponent source = rChunkElement.getAdapter(SourceComponent.class);
                if (source instanceof SourceComponent) {
                    rootNodes = ImCollections.newList((Object)((Object)source));
                } else {
                    if (!(source instanceof List)) continue;
                    rootNodes = (List)((Object)source);
                }
                this.rmScopeAnalyzer.processChunk(rChunkElement, (List<SourceComponent>)rootNodes);
            }
            for (SourceComponent sourceComponent : inlineNodes) {
                EmbeddedInlineElement inlineElement = new EmbeddedInlineElement(modelInfo.getSourceElement(), sourceComponent);
                this.rmScopeAnalyzer.processInlineNode(inlineElement, sourceComponent);
            }
        }
        finally {
            model = this.rmScopeAnalyzer.stopChunkSession();
        }
        return model;
    }

    protected void reportIssues(Data data, int flags) {
        block6: {
            try {
                SourceUnitIssueSupport issueSupport = data.adapter.getIssueSupport();
                if (issueSupport == null) {
                    return;
                }
                IssueRequestor issueRequestor = issueSupport.createIssueRequestor((SourceUnit)data.sourceUnit);
                if (issueRequestor == null) break block6;
                try {
                    this.riReporter.run(data.sourceUnit, data.getModel(), data.content, issueRequestor, flags);
                }
                finally {
                    issueRequestor.finish();
                }
            }
            catch (Exception e) {
                this.handleStatus((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, String.format("An error occurred when reporting issues for source unit %1$s.", data.sourceUnit), (Throwable)e));
            }
        }
    }

    protected void handleStatus(IStatus status) {
        MultiStatus collector = this.statusCollector;
        if (collector != null) {
            collector.add(status);
        } else {
            RCorePlugin.log(status);
        }
    }

    protected static final class Data {
        public final RSourceUnitModelContainer adapter;
        public final RSourceUnit sourceUnit;
        public final SourceContent content;
        @Nullable AstInfo ast;
        @Nullable RSourceUnitModelInfo oldModel;
        @Nullable RSourceUnitModelInfo newModel;

        public Data(RSourceUnitModelContainer adapter, SubMonitor monitor) {
            this.adapter = adapter;
            this.sourceUnit = (RSourceUnit)adapter.getSourceUnit();
            this.content = adapter.getParseContent((IProgressMonitor)monitor);
        }

        boolean isOK() {
            return this.content != null;
        }

        public AstInfo getAst() {
            return this.ast;
        }

        public RSourceUnitModelInfo getModel() {
            return this.newModel;
        }
    }
}

