/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.input;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

@NonNullByDefault
public final class StringParserInput
extends TextParserInput
implements CharSequence {
    private String source;

    public StringParserInput(int defaultBufferSize) {
        super(defaultBufferSize);
    }

    public StringParserInput() {
        this(2048);
    }

    public StringParserInput(String source) {
        this(Math.min(source.length(), 2048));
        this.source = source;
    }

    public StringParserInput reset(String source) {
        this.source = source;
        super.reset();
        return this;
    }

    @Override
    public StringParserInput init() {
        super.init();
        return this;
    }

    @Override
    public StringParserInput init(int startIndex, int stopIndex) {
        super.init(startIndex, stopIndex);
        return this;
    }

    @Override
    protected int getSourceLength() {
        return this.source.length();
    }

    @Override
    protected @Nullable String getSourceString() {
        return this.source;
    }

    @Override
    protected void doUpdateBuffer(int index, char[] buffer, int requiredLength, int recommendLength) {
        int length = Math.min(recommendLength, this.getStopIndex() - index);
        this.source.getChars(index, index + length, buffer, 0);
        this.setBuffer(buffer, 0, length);
    }

    @Override
    public int length() {
        return this.source.length();
    }

    @Override
    public char charAt(int index) {
        return this.source.charAt(index);
    }

    @Override
    public String subSequence(int start, int end) {
        return this.source.substring(start, end);
    }
}

