/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.text.core;

import java.util.IdentityHashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.ecommons.text.core.DocumentEnhancement;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DocumentEnhancementImpl
extends Position
implements DocumentEnhancement,
IDocumentPartitioningListener,
IDocumentPartitioningListenerExtension2 {
    private static final String POSITION_CATEGORY = "org.eclipse.statet.ecommons.text.DocumentEnhancement";
    private final CopyOnWriteIdentityListSet<IDocumentPartitioningListenerExtension2> partitioningListeners = new CopyOnWriteIdentityListSet();
    private @Nullable IdentityHashMap<String, Object> data;

    private static DocumentEnhancementImpl doSetup(IDocument document) throws BadLocationException, BadPositionCategoryException {
        document.addPositionCategory(POSITION_CATEGORY);
        DocumentEnhancementImpl documentEnh = new DocumentEnhancementImpl();
        document.addPosition(POSITION_CATEGORY, (Position)documentEnh);
        document.addDocumentPartitioningListener((IDocumentPartitioningListener)documentEnh);
        return documentEnh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup(IDocument document) {
        Object object = TextUtils.getLockObject(document);
        synchronized (object) {
            try {
                if (!document.containsPositionCategory(POSITION_CATEGORY)) {
                    DocumentEnhancementImpl.doSetup(document);
                }
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static DocumentEnhancementImpl get(IDocument document) {
        Object object = TextUtils.getLockObject(document);
        synchronized (object) {
            try {
                if (document.containsPositionCategory(POSITION_CATEGORY)) {
                    return (DocumentEnhancementImpl)document.getPositions(POSITION_CATEGORY)[0];
                }
                return DocumentEnhancementImpl.doSetup(document);
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addPrePartitioningListener(IDocumentPartitioningListenerExtension2 listener) {
        this.partitioningListeners.add((Object)listener);
    }

    @Override
    public void removePrePartitioningListener(IDocumentPartitioningListenerExtension2 listener) {
        this.partitioningListeners.remove((Object)listener);
    }

    public void documentPartitioningChanged(IDocument document) {
    }

    public void documentPartitioningChanged(DocumentPartitioningChangedEvent event) {
        for (IDocumentPartitioningListenerExtension2 listener : this.partitioningListeners) {
            listener.documentPartitioningChanged(event);
        }
    }

    @Override
    public @Nullable Object getData(String key) {
        IdentityHashMap<String, Object> data = this.data;
        return data != null ? data.get(key) : null;
    }

    @Override
    public void setData(String key, @Nullable Object value) {
        IdentityHashMap<String, Object> data = this.data;
        if (data == null) {
            this.data = data = new IdentityHashMap();
        }
        if (value != null) {
            data.put(key, value);
        } else {
            data.remove(key);
        }
    }
}

