/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.util.AbortException;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.source.ast.Alias;
import org.eclipse.statet.yaml.core.source.ast.Collection;
import org.eclipse.statet.yaml.core.source.ast.MapEntry;
import org.eclipse.statet.yaml.core.source.ast.NodeWithProperties;
import org.eclipse.statet.yaml.core.source.ast.Scalar;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;

@NonNullByDefault
public class ElementNameCreator
extends YamlAstVisitor {
    private final StringBuilder sb = new StringBuilder();
    private int maxLength = 100;

    public void setLengthSoftLimit(int length) {
        this.maxLength = length;
    }

    public YamlElementName createSeqEntry(int index) {
        return YamlElementName.create(82, Integer.toString(index + 1));
    }

    public YamlElementName createMapKey(@Nullable YamlAstNode node) {
        if (node == null) {
            return YamlElementName.create(0, "<?>");
        }
        switch (node.getNodeType()) {
            case SCALAR: {
                return YamlElementName.create(16, node.getText());
            }
            case ALIAS: {
                return YamlElementName.create(65, node.getText());
            }
        }
        this.sb.setLength(0);
        try {
            node.acceptInYaml(this);
        }
        catch (InvocationTargetException | AbortException throwable) {
            // empty catch block
        }
        return YamlElementName.create(96, this.sb.length() > 1 ? this.sb.substring(1) : "");
    }

    @Override
    public void visit(NodeWithProperties node) throws InvocationTargetException {
        node.getNode().acceptInYaml(this);
    }

    @Override
    public void visit(Collection node) throws InvocationTargetException {
        String close;
        String open;
        switch (node.getNodeType()) {
            case SEQ: {
                open = " [";
                close = " ]";
                break;
            }
            case MAP: {
                open = " {";
                close = " }";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.sb.append(open);
        try {
            if (node.hasChildren()) {
                node.getChild(0).acceptInYaml(this);
                int i = 1;
                while (i < node.getChildCount()) {
                    this.sb.append(',');
                    node.getChild(i).acceptInYaml(this);
                    ++i;
                }
            }
        }
        finally {
            this.sb.append(close);
        }
    }

    @Override
    public void visit(MapEntry node) throws InvocationTargetException {
        node.getKey().acceptInYaml(this);
        this.sb.append(" :");
        node.getValue().acceptInYaml(this);
    }

    private void checkLength() {
        if (this.sb.length() >= this.maxLength) {
            this.sb.append(" \u2026");
            throw new AbortException();
        }
    }

    @Override
    public void visit(Scalar node) throws InvocationTargetException {
        this.checkLength();
        String text = node.getText();
        if (text == null) {
            this.sb.append("<null>");
        } else {
            this.sb.append(" \"");
            int max = Math.max(10, this.maxLength - this.sb.length());
            if (text.length() > max) {
                this.sb.append(text, 0, max);
            } else {
                this.sb.append(text);
            }
            this.sb.append('\"');
        }
    }

    @Override
    public void visit(Alias node) throws InvocationTargetException {
        this.checkLength();
        String text = node.getText();
        this.sb.append(" *");
        if (text == null) {
            this.sb.append("<missing>");
        } else {
            this.sb.append(text);
        }
    }
}

