/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;

@NonNullByDefault
public abstract class BasicYamlSourceElement
implements YamlSourceElement {
    protected static final ImList<YamlSourceElement> NO_CHILDREN = ImCollections.emptyList();
    protected YamlElementName name;
    protected int occurrenceCount;
    protected TextRegion nameRegion;
    protected final YamlAstNode astNode;

    protected BasicYamlSourceElement(YamlAstNode astNode) {
        this.astNode = astNode;
    }

    public final String getModelTypeId() {
        return "Yaml";
    }

    public String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    @Override
    public YamlElementName getElementName() {
        return this.name;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public TextRegion getSourceRange() {
        return this.astNode;
    }

    public TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.astNode);
        }
        return null;
    }

    public int hashCode() {
        return (this.getElementType() & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicYamlSourceElement) {
            BasicYamlSourceElement other = (BasicYamlSourceElement)obj;
            return (this.getElementType() & 0xFF0) == (this.getElementType() & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.getElementType() & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals(other.getElementName());
        }
        return false;
    }
}

