/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.r.launching.IRCodeSubmitConnector;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;

public class TextConsoleConnector
implements IRCodeSubmitConnector {
    public static final String ID = "org.eclipse.statet.r.rCodeLaunchConnector.EclipseTextConsole";

    @Override
    public boolean submit(final List<String> lines, final boolean gotoConsole) throws CoreException {
        if (lines == null) {
            throw new NullPointerException();
        }
        UIAccess.checkedSyncExec((UIAccess.CheckedRunnable)new UIAccess.CheckedRunnable(){

            public void run() throws CoreException {
                IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                IWorkbenchPart activePart = page.getActivePart();
                try {
                    TextConsole console = TextConsoleConnector.this.getAndShowConsole();
                    if (console == null || console instanceof NIConsole) {
                        TextConsoleConnector.this.handleNoConsole();
                    }
                    IDocument doc = console.getDocument();
                    try {
                        int i = 0;
                        while (i < lines.size()) {
                            doc.replace(doc.getLength(), 0, String.valueOf((String)lines.get(i)) + '\n');
                            ++i;
                        }
                        if (gotoConsole) {
                            activePart = null;
                        }
                    }
                    catch (BadLocationException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, RLaunchingMessages.TextConsoleConnector_error_Other_message, (Throwable)e));
                    }
                }
                finally {
                    if (activePart != null) {
                        page.activate(activePart);
                    }
                }
            }
        });
        return true;
    }

    @Override
    public void gotoConsole() throws CoreException {
        UIAccess.checkedSyncExec((UIAccess.CheckedRunnable)new UIAccess.CheckedRunnable(){

            public void run() throws CoreException {
                TextConsole console = TextConsoleConnector.this.getAndShowConsole();
                if (console == null || console instanceof NIConsole) {
                    TextConsoleConnector.this.handleNoConsole();
                }
            }
        });
    }

    private void handleNoConsole() throws CoreException {
        throw new CoreException((IStatus)new Status(2, "org.eclipse.statet.r.ui", 0, RLaunchingMessages.TextConsoleConnector_error_NoConsole_message, null));
    }

    private TextConsole getAndShowConsole() throws CoreException {
        IConsoleView view = this.getConsoleView(true);
        IConsole console = view.getConsole();
        if (console instanceof TextConsole) {
            return (TextConsole)console;
        }
        return null;
    }

    private IConsoleView getConsoleView(boolean activateConsoleView) throws PartInitException {
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)false);
        IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
        if (activateConsoleView) {
            page.activate((IWorkbenchPart)view);
        }
        return view;
    }
}

