/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.nico.core.util.TrackWriter;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.nico.IRSrcref;

public abstract class AbstractRController
extends ToolController
implements IRBasicAdapter {
    public static final String INIT_RGRAPHIC_FACTORY_HANDLER_ID = "r/initRGraphicFactory";
    protected final List<ToolRunnable> startupsRunnables = new ArrayList<ToolRunnable>();
    protected String continuePromptText;
    protected String defaultPromptText;
    private List<TrackingConfiguration> trackingConfigurations;

    public AbstractRController(RProcess process, Map<String, Object> connectionInfo) {
        super((ToolProcess)process, connectionInfo);
        process.registerFeatureSet("org.eclipse.statet.r.basic");
    }

    public void addStartupRunnable(ToolRunnable runnable) {
        this.startupsRunnables.add(runnable);
    }

    @Override
    public RProcess getTool() {
        return (RProcess)super.getTool();
    }

    @Override
    public RWorkspace getWorkspaceData() {
        return (RWorkspace)super.getWorkspaceData();
    }

    protected SystemRunnable createCancelPostRunnable(final int options) {
        return new ToolController.ControllerSystemRunnable(this, "common/cancel/post", "Reset prompt"){

            public void run(ToolService s, ProgressMonitor m) throws StatusException {
                if (!AbstractRController.this.isTerminated()) {
                    AbstractRController.this.postCancelTask(options, m);
                }
            }
        };
    }

    protected void postCancelTask(int options, ProgressMonitor m) throws StatusException {
        ToolStreamProxy streams = this.getStreams();
        SubmitType submitType = this.getCurrentSubmitType();
        String text = String.valueOf(this.fCurrentPrompt.text) + ((this.fCurrentPrompt.meta & 0x100) != 0 ? "(Input cancelled)" : "(Command cancelled)") + this.fLineSeparator;
        streams.getInfoStreamMonitor().append(text, submitType, this.fCurrentPrompt.meta);
    }

    public boolean supportsBusy() {
        return false;
    }

    public boolean isBusy() {
        return false;
    }

    protected void initRunnableAdapterL() {
        super.initRunnableAdapterL();
        this.setDefaultPromptTextL("> ");
        this.setContinuePromptText("+ ");
    }

    protected void setTracksConfig(List<TrackingConfiguration> config) {
        this.trackingConfigurations = config;
    }

    protected void initTracks(ProgressMonitor m, List<Status> warnings) throws StatusException {
        if (this.trackingConfigurations != null) {
            m.setWorkRemaining(this.trackingConfigurations.size());
            ArrayList<TrackWriter> tracks = new ArrayList<TrackWriter>(this.trackingConfigurations.size());
            for (TrackingConfiguration trackingConfig : this.trackingConfigurations) {
                TrackWriter tracker = new TrackWriter((ToolController)this, trackingConfig);
                Status status = tracker.init(m.newSubMonitor(1));
                if (status.getSeverity() == 0) {
                    tracks.add(tracker);
                    this.addDisposable((Disposable)tracker);
                    continue;
                }
                warnings.add(status);
            }
            this.setTracks(tracks);
        }
    }

    public ToolRunnable createCommandRunnable(String command, SubmitType type) {
        return new RCommandRunnable(command, type);
    }

    public void setDefaultPromptTextL(String text) {
        if (text == null || text.equals(this.defaultPromptText)) {
            return;
        }
        this.defaultPromptText = text = text.intern();
        super.setDefaultPromptTextL(text);
    }

    public void setContinuePromptText(String text) {
        if (text == null || text.equals(this.continuePromptText)) {
            return;
        }
        this.continuePromptText = text = text.intern();
    }

    protected void doRunSuspendedLoopL(int o, int level, Queue.Section queueSection) {
        this.briefChanged(1);
        RWorkspace.Changes savedChanges = this.getWorkspaceData().saveChanges();
        try {
            super.doRunSuspendedLoopL(o, level, queueSection);
        }
        finally {
            this.getWorkspaceData().restoreChanges(savedChanges);
        }
    }

    public Set<Long> getLazyEnvironments(ProgressMonitor m) {
        return null;
    }

    public void submitFileCommandToConsole(String[] lines, SourceUnit file, ProgressMonitor m) throws StatusException {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.submitToConsole(line, m);
            ++n2;
        }
    }

    public void submitCommandToConsole(String[] lines, IRSrcref srcref, ProgressMonitor m) throws StatusException {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.submitToConsole(line, m);
            ++n2;
        }
    }

    protected void doQuitL(ProgressMonitor m) throws StatusException {
        this.submitToConsole("q()", m);
    }

    @Override
    public void quit(ProgressMonitor m) throws StatusException {
        this.doQuitL(m);
    }

    public static class RCommandRunnable
    extends ToolController.ConsoleCommandRunnable {
        protected RCommandRunnable(String text, SubmitType type) {
            super(text, type);
        }

        public boolean canRunIn(Tool tool) {
            return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            IRBasicAdapter r = (IRBasicAdapter)service;
            r.briefAboutToChange();
            try {
                super.run((ToolService)r, m);
            }
            finally {
                if ((r.getPrompt().meta & 0x100) == 0) {
                    r.briefChanged(1);
                }
            }
        }
    }
}

