/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.ltk.ui.EditorUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IEditorStatusLine;

@NonNullByDefault
public class ToggleCommentHandler
extends AbstractHandler {
    private static final ConcurrentHashMap<String, Pattern> DEFAULT_PREFIX_MAP = new ConcurrentHashMap();
    protected static final Pattern HTML_SPACE_PREFIX_PATTERN = Pattern.compile("^[ \\t]*(" + Pattern.quote("<!--") + " ?)");
    protected static final Pattern HTML_SPACE_POSTFIX_PATTERN = Pattern.compile("( ?" + Pattern.quote("-->") + "[ \\t]*)$");
    private final SourceEditor1 editor;
    private @Nullable ITextOperationTarget operationTarget;
    private final Map<String, ImList<String>> contentTypePrefixes = new IdentityHashMap<String, ImList<String>>();

    protected static Pattern getDefaultPrefixPattern(String prefix) {
        Pattern pattern = DEFAULT_PREFIX_MAP.get(prefix);
        if (pattern == null) {
            pattern = Pattern.compile("^[ \\t]*(" + Pattern.quote(prefix) + ")");
            DEFAULT_PREFIX_MAP.putIfAbsent(prefix, pattern);
        }
        return pattern;
    }

    public ToggleCommentHandler(SourceEditor1 editor) {
        this.editor = editor;
        this.setBaseEnabled(false);
    }

    protected SourceEditor1 getEditor() {
        return this.editor;
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        if (this.editor.getViewer() instanceof SourceEditorViewer && !this.editor.isEditorInputModifiable()) {
            this.setBaseEnabled(false);
            return;
        }
        ITextOperationTarget operationTarget = this.operationTarget;
        if (operationTarget == null) {
            this.operationTarget = operationTarget = this.editor.getAdapter(ITextOperationTarget.class);
        }
        this.setBaseEnabled(operationTarget != null && operationTarget.canDoOperation(11) && operationTarget.canDoOperation(12));
    }

    private @Nullable ITextSelection getSelection() {
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        return selection instanceof ITextSelection ? (ITextSelection)selection : null;
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.editor.validateEditorInputState() || !this.isEnabled()) {
            return null;
        }
        final AbstractDocument document = (AbstractDocument)this.editor.getViewer().getDocument();
        final ITextSelection selection = this.getSelection();
        if (document == null || selection == null) {
            return null;
        }
        final int operationCode = this.isSelectionCommented(document, selection) ? 12 : 11;
        Shell shell = this.editor.getSite().getShell();
        if (!this.operationTarget.canDoOperation(operationCode)) {
            this.signalError();
            return null;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                ToggleCommentHandler.this.run(document, selection, operationCode);
            }
        });
        return null;
    }

    protected void run(AbstractDocument document, ITextSelection selection, int operationCode) {
        this.doRunOperation(operationCode);
    }

    protected void doRunOperation(int operationCode) {
        this.operationTarget.doOperation(operationCode);
    }

    protected ImList<String> getPrefixes(String contentType) {
        ImList prefixes = this.contentTypePrefixes.get(contentType);
        if (prefixes == null) {
            @NonNull Object[] array = ((SourceEditorViewer)this.editor.getViewer()).getDefaultPrefixes(contentType);
            if (array != null) {
                int numEmpty = 0;
                int i = 0;
                while (i < array.length) {
                    if (array[i].isEmpty()) {
                        ++numEmpty;
                    }
                    ++i;
                }
                if (numEmpty > 0) {
                    String[] nonemptyPrefixes = new String[array.length - numEmpty];
                    int i2 = 0;
                    int j = 0;
                    while (i2 < array.length) {
                        Object prefix = array[i2];
                        if (!((String)prefix).isEmpty()) {
                            nonemptyPrefixes[j++] = prefix;
                        }
                        ++i2;
                    }
                    array = nonemptyPrefixes;
                }
                prefixes = ImCollections.newList((Object[])array);
            } else {
                prefixes = ImCollections.emptyList();
            }
            this.contentTypePrefixes.put(contentType, (ImList<String>)prefixes);
        }
        return prefixes;
    }

    protected @Nullable Pattern getPrefixPattern(String contentType, String prefix) {
        return ToggleCommentHandler.getDefaultPrefixPattern(prefix);
    }

    protected @Nullable Pattern getPostfixPattern(String contentType, String prefix) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSelectionCommented(AbstractDocument document, ITextSelection selection) {
        if (selection.getStartLine() < 0 || selection.getEndLine() < 0) {
            return false;
        }
        try {
            IRegion block = EditorUtils.getTextBlockFromSelection((IDocument)document, selection.getOffset(), selection.getLength());
            @NonNull ITypedRegion[] regions = document.computePartitioning(this.editor.getDocumentContentInfo().getPartitioning(), block.getOffset(), block.getLength(), false);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IDocument)document, (IRegion)regions[i]);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                ImList<String> prefixes = this.getPrefixes(regions[i].getType());
                if (prefixes != null && !prefixes.isEmpty() && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, (IDocument)document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException | BadPartitioningException e) {
            this.log((Exception)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBlockCommented(int startLine, int endLine, ImList<String> prefixes, IDocument document) {
        try {
            int i = startLine;
            while (true) {
                if (i > endLine) {
                    return true;
                }
                IRegion lineInfo = document.getLineInformation(i);
                String text = document.get(lineInfo.getOffset(), lineInfo.getLength());
                int index = StringUtils.firstIndexOfAny((String)text, prefixes);
                if (index == -1 || !StringUtils.isTrimEmpty((String)text, (int)0, (int)index)) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            this.log((Exception)((Object)e));
            return false;
        }
    }

    protected int getFirstCompleteLineOfRegion(IDocument document, IRegion region) throws BadLocationException {
        int startLine = document.getLineOfOffset(region.getOffset());
        int offset = document.getLineOffset(startLine);
        if (offset >= region.getOffset()) {
            return startLine;
        }
        offset = document.getLineOffset(startLine + 1);
        return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
    }

    protected void doPrefix(AbstractDocument document, IRegion region, String prefix) throws BadLocationException, BadPartitioningException {
        int startLine = document.getLineOfOffset(region.getOffset());
        int stopLine = region.getLength() > 0 ? document.getLineOfOffset(region.getOffset() + region.getLength() - 1) : startLine;
        MultiTextEdit multi = new MultiTextEdit(region.getOffset(), region.getLength());
        int line = startLine;
        while (line <= stopLine) {
            multi.addChild((TextEdit)new InsertEdit(document.getLineOffset(line), prefix));
            ++line;
        }
        DocumentRewriteSession rewriteSession = document.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        try {
            multi.apply((IDocument)document, 0);
        }
        finally {
            document.stopRewriteSession(rewriteSession);
        }
    }

    protected void doPrefix(AbstractDocument document, IRegion region, String prefix, String postfix) throws BadLocationException, BadPartitioningException {
        int startLine = document.getLineOfOffset(region.getOffset());
        int stopLine = region.getLength() > 0 ? document.getLineOfOffset(region.getOffset() + region.getLength() - 1) : startLine;
        MultiTextEdit multi = new MultiTextEdit(region.getOffset(), region.getLength());
        int line = startLine;
        while (line <= stopLine) {
            IRegion lineInfo = document.getLineInformation(line);
            multi.addChild((TextEdit)new InsertEdit(lineInfo.getOffset(), prefix));
            multi.addChild((TextEdit)new InsertEdit(lineInfo.getOffset() + lineInfo.getLength(), postfix));
            ++line;
        }
        DocumentRewriteSession rewriteSession = document.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        try {
            multi.apply((IDocument)document, 0);
        }
        finally {
            document.stopRewriteSession(rewriteSession);
        }
    }

    protected void doStripPrefix(AbstractDocument document, IRegion region) throws BadLocationException, BadPartitioningException {
        int startLine = document.getLineOfOffset(region.getOffset());
        int stopLine = region.getLength() > 0 ? document.getLineOfOffset(region.getOffset() + region.getLength() - 1) : startLine;
        MultiTextEdit multi = new MultiTextEdit(region.getOffset(), region.getLength());
        int line = startLine;
        while (line <= stopLine) {
            Matcher matcher;
            IRegion lineInfo = document.getLineInformation(line);
            String contentType = document.getContentType(this.editor.getDocumentContentInfo().getPartitioning(), lineInfo.getOffset(), false);
            ImList<String> prefixes = this.getPrefixes(contentType);
            String text = document.get(lineInfo.getOffset(), lineInfo.getLength());
            StringUtils.Match prefix = (StringUtils.Match)ObjectUtils.nonNullAssert((Object)StringUtils.firstMatchOfAny((String)text, prefixes));
            Pattern pattern = this.getPrefixPattern(contentType, prefix.getString());
            if (pattern != null) {
                matcher = pattern.matcher(text);
                matcher.reset(text);
                if (matcher.find()) {
                    multi.addChild((TextEdit)new DeleteEdit(lineInfo.getOffset() + matcher.start(1), matcher.end(1) - matcher.start(1)));
                }
            } else {
                multi.addChild((TextEdit)new DeleteEdit(lineInfo.getOffset() + prefix.getStartIndex(), prefix.getLength()));
            }
            if ((pattern = this.getPostfixPattern(contentType, prefix.getString())) != null && (matcher = pattern.matcher(text)).find()) {
                multi.addChild((TextEdit)new DeleteEdit(lineInfo.getOffset() + matcher.start(1), matcher.end(1) - matcher.start(1)));
            }
            ++line;
        }
        DocumentRewriteSession rewriteSession = document.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
        try {
            multi.apply((IDocument)document, 0);
        }
        finally {
            document.stopRewriteSession(rewriteSession);
        }
    }

    protected void signalError() {
        IEditorStatusLine statusLine = this.editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, EditingMessages.ToggleCommentAction_error, null);
        }
        this.editor.getViewer().getTextWidget().getDisplay().beep();
    }

    protected void log(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", 0, "An error ocurred when executing toggle comment operation.", (Throwable)e), 1);
    }
}

