/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core;

import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class BasicTextLineInformation
implements TextLineInformation,
Immutable {
    private final int n;
    private final int[] startOffsets;

    public BasicTextLineInformation(int[] offsets) {
        this.n = offsets.length - 1;
        this.startOffsets = offsets;
    }

    @Override
    public int getNumberOfLines() {
        return this.n;
    }

    @Override
    public int getLineOfOffset(int offset) {
        if (offset < 0 || offset > this.startOffsets[this.n]) {
            throw new IllegalArgumentException("offset= " + offset);
        }
        int low = 0;
        int high = this.n - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int lineOffset = this.startOffsets[mid];
            if (lineOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (lineOffset > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    @Override
    public int getStartOffset(int line) {
        if (line < 0 || line >= this.n) {
            throw new IllegalArgumentException("line= " + line);
        }
        return this.startOffsets[line];
    }

    @Override
    public int getEndOffset(int line) {
        if (line < 0 || line >= this.n) {
            throw new IllegalArgumentException("line= " + line);
        }
        return this.startOffsets[line + 1];
    }

    @Override
    public int getLength(int line) {
        if (line < 0 || line >= this.n) {
            throw new IllegalArgumentException("line= " + line);
        }
        return this.startOffsets[line + 1] - this.startOffsets[line];
    }

    @Override
    public TextRegion getRegion(int line) {
        if (line < 0 || line >= this.n) {
            throw new IllegalArgumentException("line= " + line);
        }
        return new BasicTextRegion(this.startOffsets[line], this.startOffsets[line + 1]);
    }

    public int hashCode() {
        return this.startOffsets.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TextLineInformation) {
            TextLineInformation other = (TextLineInformation)obj;
            int n = this.getNumberOfLines();
            if (n != other.getNumberOfLines()) {
                return false;
            }
            int line = 0;
            while (line < n) {
                if (this.getStartOffset(line) != other.getStartOffset(line)) {
                    return false;
                }
                ++line;
            }
            return this.getEndOffset(n) == other.getEndOffset(n);
        }
        return false;
    }
}

