/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.config;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.data.convert.ConversionFailedException;
import org.eclipse.statet.ecommons.waltable.data.validate.ValidationFailedException;
import org.eclipse.statet.ecommons.waltable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.editor.IEditErrorHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogErrorHandling
extends AbstractEditErrorHandler {
    protected ICellEditor editor;
    protected boolean allowCommit = false;
    private String failureShellTitle = Messages.getString("DialogErrorHandlingStrategy.failureTitle");
    private String conversionFailureShellTitle = Messages.getString("DialogErrorHandlingStrategy.conversionFailureTitle");
    private String validationFailureShellTitle = Messages.getString("DialogErrorHandlingStrategy.validationFailureTitle");
    private String changeButtonLabel = Messages.getString("DialogErrorHandlingStrategy.warningDialog.changeButton");
    private String discardButtonLabel = Messages.getString("DialogErrorHandlingStrategy.warningDialog.discardButton");
    private final String commitButtonLabel = Messages.getString("DialogErrorHandlingStrategy.warningDialog.commitButton");

    public DialogErrorHandling() {
        this(null, false);
    }

    public DialogErrorHandling(boolean allowCommit) {
        this(null, allowCommit);
    }

    public DialogErrorHandling(IEditErrorHandler underlyingErrorHandler) {
        this(underlyingErrorHandler, false);
    }

    public DialogErrorHandling(IEditErrorHandler underlyingErrorHandler, boolean allowCommit) {
        super(underlyingErrorHandler);
        this.allowCommit = allowCommit;
    }

    @Override
    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        this.editor = cellEditor;
        String shellTitle = this.failureShellTitle;
        if (e instanceof ConversionFailedException && this.conversionFailureShellTitle != null) {
            shellTitle = this.conversionFailureShellTitle;
        } else if (e instanceof ValidationFailedException && this.validationFailureShellTitle != null) {
            shellTitle = this.validationFailureShellTitle;
        }
        this.showWarningDialog(e.getLocalizedMessage(), shellTitle);
    }

    protected void showWarningDialog(String dialogMessage, String dialogTitle) {
        if (!this.isWarningDialogActive() && dialogMessage != null) {
            String[] stringArray;
            if (this.allowCommit) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = this.changeButtonLabel;
                stringArray2[1] = this.discardButtonLabel;
                stringArray = stringArray2;
                stringArray2[2] = this.commitButtonLabel;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.changeButtonLabel;
                stringArray = stringArray3;
                stringArray3[1] = this.discardButtonLabel;
            }
            String[] buttonLabels = stringArray;
            MessageDialog warningDialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 4, buttonLabels, 0);
            long returnCode = warningDialog.open();
            if (returnCode == 1L) {
                this.editor.close();
            } else if (returnCode == 2L) {
                this.editor.commit(null, true, true);
            }
        }
    }

    protected boolean isWarningDialogActive() {
        Shell control = Display.getCurrent().getActiveShell();
        return control != null && (this.conversionFailureShellTitle.equals(control.getText()) || this.validationFailureShellTitle.equals(control.getText()) || this.failureShellTitle.equals(control.getText()));
    }

    public String getFailureShellTitle() {
        return this.failureShellTitle;
    }

    public void setFailureShellTitle(String failureShellTitle) {
        this.failureShellTitle = failureShellTitle;
    }

    public String getConversionFailureShellTitle() {
        return this.conversionFailureShellTitle;
    }

    public void setConversionFailureShellTitle(String conversionFailureShellTitle) {
        this.conversionFailureShellTitle = conversionFailureShellTitle;
    }

    public String getValidationFailureShellTitle() {
        return this.validationFailureShellTitle;
    }

    public void setValidationFailureShellTitle(String validationFailureShellTitle) {
        this.validationFailureShellTitle = validationFailureShellTitle;
    }

    public String getChangeButtonLabel() {
        return this.changeButtonLabel;
    }

    public void setChangeButtonLabel(String changeButtonLabel) {
        this.changeButtonLabel = changeButtonLabel;
    }

    public String getDiscardButtonLabel() {
        return this.discardButtonLabel;
    }

    public void setDiscardButtonLabel(String discardButtonLabel) {
        this.discardButtonLabel = discardButtonLabel;
    }
}

