/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import java.util.Map;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.ClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public abstract class ForwardLayer<TLayerDim extends ForwardLayerDim<? extends ForwardLayer<TLayerDim>>>
extends AbstractLayer<TLayerDim> {
    private final Layer underlyingLayer;

    public ForwardLayer(Layer underlyingLayer, @Nullable LayerPainter layerPainter) {
        super(layerPainter);
        this.underlyingLayer = (Layer)ObjectUtils.nonNullAssert((Object)underlyingLayer);
        this.underlyingLayer.setClientAreaProvider(this.getClientAreaProvider());
        this.underlyingLayer.addLayerListener(this);
    }

    public ForwardLayer(Layer underlyingLayer) {
        this(underlyingLayer, null);
    }

    protected final Layer getUnderlyingLayer() {
        return this.underlyingLayer;
    }

    @Override
    public void dispose() {
        this.underlyingLayer.dispose();
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        this.underlyingLayer.saveState(prefix, properties);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        this.underlyingLayer.loadState(prefix, properties);
        super.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        this.underlyingLayer.configure(configRegistry, uiBindingRegistry);
        super.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public LayerPainter getLayerPainter() {
        LayerPainter layerPainter = super.getLayerPainter();
        return layerPainter != null ? layerPainter : this.underlyingLayer.getLayerPainter();
    }

    @Override
    protected LayerPainter createPainter() {
        return null;
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void setClientAreaProvider(ClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
        this.underlyingLayer.setClientAreaProvider(clientAreaProvider);
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        LayerCell underlyingCell = this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
        return this.createCell(underlyingCell.getDim(Orientation.HORIZONTAL), underlyingCell.getDim(Orientation.VERTICAL), underlyingCell);
    }

    protected LayerCell createCell(LayerCellDim hDim, LayerCellDim vDim, LayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell);
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public Layer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return this.underlyingLayer;
    }
}

