/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.docmlet.wikitext.core.ast.Link;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;

@NonNullByDefault
public class MarkupOpenHyperlinkHandler {
    static @Nullable Link searchLink(WikitextSourceUnit sourceUnit, IRegion region) {
        AstInfo astInfo = sourceUnit.getAstInfo("Wikidoc", true, (IProgressMonitor)new NullProgressMonitor());
        if (astInfo != null) {
            AstSelection astSelection = AstSelection.search((AstNode)astInfo.getRoot(), (int)region.getOffset(), (int)(region.getOffset() + region.getLength()), (int)3);
            AstNode node = astSelection.getCovering();
            while (node instanceof WikitextAstNode) {
                if (node instanceof Link) {
                    return (Link)node;
                }
                node = node.getParent();
            }
        }
        return null;
    }

    static List<IFile> refLocalFile(SourceEditor editor, Link link) {
        String href = link.getUri();
        if (href != null && href.indexOf(58) == -1 && href.length() > 1 && href.charAt(0) != '/') {
            try {
                IFile currentFile;
                IFile refFile;
                Object resource = editor.getSourceUnit().getResource();
                if (resource instanceof IFile && (refFile = (currentFile = (IFile)resource).getParent().getFile((IPath)new Path(href))) != null) {
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    if (refFile.exists()) {
                        files.add(refFile);
                    } else {
                        int dotIdx;
                        IContainer parent = refFile.getParent();
                        if (parent.exists() && (dotIdx = refFile.getName().lastIndexOf(46)) >= 0) {
                            IResource[] children;
                            String mainName = refFile.getName().substring(0, dotIdx + 1);
                            IResource[] iResourceArray = children = parent.members();
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource child = iResourceArray[n2];
                                if (child.getType() == 1 && child.getName().startsWith(mainName)) {
                                    files.add((IFile)child);
                                }
                                ++n2;
                            }
                        }
                    }
                    return files;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return ImCollections.emptyList();
    }
}

