/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.List;
import java.util.Objects;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.rmodel.RSourceModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;

@NonNullByDefault
public abstract class EmbeddedRBuildElement
implements BuildSourceFrameElement {
    protected final SourceStructElement<?, ?> parent;
    protected final AstNode node;
    private final RElementName name;
    protected final @Nullable TextRegion nameRegion;
    int occurrenceCount;
    BuildSourceFrame envir;
    List<? extends RLangSourceElement> sourceChildrenProtected = RSourceModel.NO_R_SOURCE_CHILDREN;

    public EmbeddedRBuildElement(SourceStructElement<?, ?> parent, AstNode node, RElementName name, @Nullable TextRegion nameRegion) {
        this.parent = parent;
        this.node = node;
        this.name = name;
        this.nameRegion = nameRegion;
    }

    @Override
    public void setSourceChildren(List<? extends RLangSourceElement> children) {
        this.sourceChildrenProtected = children;
    }

    @Override
    public BuildSourceFrame getBuildFrame() {
        return this.envir;
    }

    public final String getModelTypeId() {
        return "R";
    }

    @Override
    public RElementName getElementName() {
        return this.name;
    }

    public final String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 10);
        sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    @Override
    public RSourceUnit getSourceUnit() {
        return (RSourceUnit)this.parent.getSourceUnit();
    }

    public boolean exists() {
        return this.parent.exists();
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    @Override
    public @Nullable RElement<?> getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return false;
    }

    @Override
    public List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return RSourceModel.NO_R_SOURCE_CHILDREN;
    }

    public @Nullable SourceStructElement<?, ?> getSourceParent() {
        return this.parent;
    }

    @Override
    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return LtkModelUtils.hasChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return LtkModelUtils.getChildren(this.sourceChildrenProtected, filter);
    }

    public TextRegion getSourceRange() {
        return this.node;
    }

    public @Nullable TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RFrame.class) {
            return (T)this.envir;
        }
        if (adapterType == AstNode.class) {
            return (T)this.node;
        }
        return null;
    }

    public int hashCode() {
        return 640 * Objects.hashCode(this.name.getSegmentName()) + this.occurrenceCount;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EmbeddedRBuildElement) {
            EmbeddedRBuildElement other = (EmbeddedRBuildElement)obj;
            return this.occurrenceCount == other.occurrenceCount && this.name.equals(other.name);
        }
        return false;
    }
}

