/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.edb.core.EmbeddedDB;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.pkgmanager.Change;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgChangeSet;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgListImpl;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfo;
import org.eclipse.statet.r.core.pkgmanager.RPkgInfo;
import org.eclipse.statet.rj.renv.core.BasicRPkgCompilation;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;

final class DB {
    private final REnv rEnv;
    private final Map<String, Integer> libIdMap = new HashMap<String, Integer>();
    private final ConnectionFactory connectionFactory;
    private Connection connection;
    private PreparedStatement libAddStatement;
    private PreparedStatement pkgDeleteStatement;
    private PreparedStatement pkgAddStatement;
    private PreparedStatement pkgChangeStatement;

    private static RLibLocation getLibLocation(List<? extends RLibGroup> envLibs, String path) {
        for (RLibGroup rLibGroup : envLibs) {
            for (RLibLocation location : rLibGroup.getLibLocations()) {
                if (!path.equals(location.getDirectory())) continue;
                return location;
            }
        }
        return null;
    }

    static DB create(REnv rEnv, IFileStore parent) {
        try {
            File file = parent.getChild("db").toLocalFile(0, null);
            ConnectionFactory connectionFactory = EmbeddedDB.createConnectionFactory((String)file.getAbsolutePath());
            return new DB(rEnv, connectionFactory);
        }
        catch (CoreException e) {
            return null;
        }
    }

    private DB(REnv rEnv, ConnectionFactory connectionFactory) throws CoreException {
        this.rEnv = rEnv;
        this.connectionFactory = connectionFactory;
    }

    private Connection getConnection() throws SQLException {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    return this.connection;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.closeOnError();
        }
        this.connection = this.connectionFactory.createConnection();
        this.connection.setAutoCommit(false);
        return this.connection;
    }

    private void closeOnError() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
            this.libAddStatement = null;
            this.pkgDeleteStatement = null;
            this.pkgAddStatement = null;
            this.pkgChangeStatement = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BasicRPkgCompilation<IRPkgInfo> loadInstalled(List<? extends RLibGroup> envLibs) {
        try {
            ArrayList<String> removeLibPath;
            BasicRPkgCompilation newInstalled;
            block19: {
                this.checkDB();
                newInstalled = new BasicRPkgCompilation(8);
                removeLibPath = null;
                Connection connection = this.getConnection();
                Throwable throwable = null;
                Object var6_9 = null;
                try {
                    Statement libStatement = connection.createStatement();
                    try {
                        try (PreparedStatement pkgStatement = connection.prepareStatement("select NAME, VERSION, BUILT, TITLE, FLAGS, INST_STAMP, REPO_ID from RENV.PKGS where (LIB_ID= ?)");){
                            ResultSet libResult = libStatement.executeQuery("select LIB_ID, LIB_PATH from RENV.LIBPATHS");
                            while (libResult.next()) {
                                String libPath = libResult.getString(2);
                                RLibLocation location = DB.getLibLocation(envLibs, libPath);
                                if (location == null) {
                                    if (removeLibPath == null) {
                                        removeLibPath = new ArrayList<String>();
                                    }
                                    removeLibPath.add(libPath);
                                    continue;
                                }
                                int id = libResult.getInt(1);
                                this.libIdMap.put(location.getDirectory(), id);
                                RPkgListImpl<RPkgInfo> list = new RPkgListImpl<RPkgInfo>(16);
                                newInstalled.add(location.getDirectory(), list);
                                pkgStatement.setInt(1, id);
                                ResultSet pkgResult = pkgStatement.executeQuery();
                                while (pkgResult.next()) {
                                    RPkgInfo pkg = new RPkgInfo(pkgResult.getString(1), RNumVersion.create((String)pkgResult.getString(2)), pkgResult.getString(3), pkgResult.getString(4), location, pkgResult.getInt(5), pkgResult.getLong(6), pkgResult.getString(7));
                                    list.add(pkg);
                                }
                            }
                        }
                        if (libStatement == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (libStatement == null) throw throwable;
                        libStatement.close();
                        throw throwable;
                    }
                    libStatement.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (removeLibPath == null) return newInstalled;
            this.clean(removeLibPath);
            return newInstalled;
        }
        catch (SQLException e) {
            this.closeOnError();
            String name = this.rEnv.getName();
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", NLS.bind((String)"An error occurred when loading R package information of the R environment ''{0}''.", (Object)name), (Throwable)e));
            return null;
        }
    }

    private void checkDB() throws SQLException {
        Connection connection = this.getConnection();
        ResultSet schemas = connection.getMetaData().getSchemas(null, "RENV");
        while (schemas.next()) {
            if (!"RENV".equals(schemas.getString(1))) continue;
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement statement = connection.createStatement();){
                statement.execute("create table RENV.LIBPATHS (LIB_ID int not null primary key generated always as identity, LIB_PATH varchar(4096) not null unique, STAMP bigint)");
                statement.execute("create table RENV.PKGS (LIB_ID int not null references RENV.LIBPATHS on delete cascade, NAME varchar(64) not null, VERSION varchar(64) not null, BUILT varchar(256) not null, TITLE varchar(256) not null, FLAGS int, INST_STAMP bigint, REPO_ID varchar(256), primary key (LIB_ID, NAME))");
                connection.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.closeOnError();
            throw e;
        }
    }

    private void clean(List<String> removeLibPath) throws SQLException {
        Connection connection = this.getConnection();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PreparedStatement statement = connection.prepareStatement("delete from RENV.LIBPATHS where (LIB_PATH= ?)");){
                for (String libPath : removeLibPath) {
                    statement.setString(1, libPath);
                    statement.execute();
                }
                connection.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.closeOnError();
            throw e;
        }
    }

    void updatePkgs(Change change) {
        try {
            Integer id;
            Connection connection = this.getConnection();
            RPkgChangeSet changeSet = change.installedPkgs;
            if (!changeSet.deleted.isEmpty()) {
                if (this.pkgDeleteStatement == null) {
                    this.pkgDeleteStatement = connection.prepareStatement("delete from RENV.PKGS where (LIB_ID= ? and NAME= ?)");
                }
                for (IRPkgInfo pkg : changeSet.deleted) {
                    id = this.libIdMap.get(pkg.getLibLocation().getDirectory());
                    this.pkgDeleteStatement.setInt(1, id);
                    this.pkgDeleteStatement.setString(2, pkg.getName());
                    this.pkgDeleteStatement.execute();
                }
            }
            if (!changeSet.added.isEmpty()) {
                if (this.pkgAddStatement == null) {
                    this.pkgAddStatement = connection.prepareStatement("insert into RENV.PKGS (LIB_ID, NAME, VERSION, BUILT, TITLE, FLAGS, INST_STAMP, REPO_ID) values (? , ?, ?, ?, ?, ?, ?, ?)");
                }
                for (IRPkgInfo pkg : changeSet.added) {
                    id = this.libIdMap.get(pkg.getLibLocation().getDirectory());
                    if (id == null) {
                        id = this.addLib(connection, pkg.getLibLocation());
                    }
                    this.pkgAddStatement.setInt(1, id);
                    this.pkgAddStatement.setString(2, pkg.getName());
                    this.pkgAddStatement.setString(3, pkg.getVersion().toString());
                    this.pkgAddStatement.setString(4, pkg.getBuilt());
                    this.pkgAddStatement.setString(5, pkg.getTitle());
                    this.pkgAddStatement.setInt(6, pkg.getFlags());
                    this.pkgAddStatement.setLong(7, pkg.getInstallStamp());
                    this.pkgAddStatement.setString(8, pkg.getRepoId());
                    this.pkgAddStatement.execute();
                }
            }
            if (!changeSet.changed.isEmpty()) {
                if (this.pkgChangeStatement == null) {
                    this.pkgChangeStatement = connection.prepareStatement("update RENV.PKGS set VERSION= ?, BUILT= ?, TITLE= ?, FLAGS= ?, INST_STAMP= ?, REPO_ID= ? where (LIB_ID= ? and NAME= ?)");
                }
                for (IRPkgInfo pkg : changeSet.changed) {
                    id = this.libIdMap.get(pkg.getLibLocation().getDirectory());
                    this.pkgChangeStatement.setInt(7, id);
                    this.pkgChangeStatement.setString(8, pkg.getName());
                    this.pkgChangeStatement.setString(1, pkg.getVersion().toString());
                    this.pkgChangeStatement.setString(2, pkg.getBuilt());
                    this.pkgChangeStatement.setString(3, pkg.getTitle());
                    this.pkgChangeStatement.setInt(4, pkg.getFlags());
                    this.pkgChangeStatement.setLong(5, pkg.getInstallStamp());
                    this.pkgChangeStatement.setString(6, pkg.getRepoId());
                    this.pkgChangeStatement.execute();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.closeOnError();
            String name = this.rEnv.getName();
            RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", NLS.bind((String)"An error occurred when saving R package information of the R environment ''{0}''.", (Object)name), (Throwable)e));
        }
    }

    private Integer addLib(Connection connection, RLibLocation location) throws SQLException {
        if (this.libAddStatement == null) {
            this.libAddStatement = connection.prepareStatement("insert into RENV.LIBPATHS (LIB_PATH) values (?)", new String[]{"LIB_ID"});
        }
        this.libAddStatement.setString(1, location.getDirectory());
        this.libAddStatement.execute();
        ResultSet result = this.libAddStatement.getGeneratedKeys();
        if (result.next()) {
            Integer id = result.getInt(1);
            this.libIdMap.put(location.getDirectory(), id);
            return id;
        }
        throw new SQLException("Unexpected result");
    }

    private static final class REnvDB {
        static final String NAME = "RENV";

        private REnvDB() {
        }

        static final class LibPaths {
            static final String NAME = "LIBPATHS";
            static final String QNAME = "RENV.LIBPATHS";
            static final String COL_ID = "LIB_ID";
            static final String COL_LIB_PATH = "LIB_PATH";
            static final String COL_STAMP = "STAMP";
            static final String DEFINE_1 = "create table RENV.LIBPATHS (LIB_ID int not null primary key generated always as identity, LIB_PATH varchar(4096) not null unique, STAMP bigint)";
            static final String OP_insert = "insert into RENV.LIBPATHS (LIB_PATH) values (?)";
            static final String OP_delete_byPath = "delete from RENV.LIBPATHS where (LIB_PATH= ?)";
            static final String OP_getAll = "select LIB_ID, LIB_PATH from RENV.LIBPATHS";

            LibPaths() {
            }
        }

        static final class Pkgs {
            static final String NAME = "PKGS";
            static final String QNAME = "RENV.PKGS";
            static final String COL_LIB_ID = "LIB_ID";
            static final String COL_NAME = "NAME";
            static final String COL_VERSION = "VERSION";
            static final String COL_BUILT = "BUILT";
            static final String COL_TITLE = "TITLE";
            static final String COL_FLAGS = "FLAGS";
            static final String COL_INST_STAMP = "INST_STAMP";
            static final String COL_REPO_ID = "REPO_ID";
            static final String DEFINE_1 = "create table RENV.PKGS (LIB_ID int not null references RENV.LIBPATHS on delete cascade, NAME varchar(64) not null, VERSION varchar(64) not null, BUILT varchar(256) not null, TITLE varchar(256) not null, FLAGS int, INST_STAMP bigint, REPO_ID varchar(256), primary key (LIB_ID, NAME))";
            static final String OP_insert = "insert into RENV.PKGS (LIB_ID, NAME, VERSION, BUILT, TITLE, FLAGS, INST_STAMP, REPO_ID) values (? , ?, ?, ?, ?, ?, ?, ?)";
            static final String OP_update = "update RENV.PKGS set VERSION= ?, BUILT= ?, TITLE= ?, FLAGS= ?, INST_STAMP= ?, REPO_ID= ? where (LIB_ID= ? and NAME= ?)";
            static final String OP_delete = "delete from RENV.PKGS where (LIB_ID= ? and NAME= ?)";
            static final String OP_get_ofLib = "select NAME, VERSION, BUILT, TITLE, FLAGS, INST_STAMP, REPO_ID from RENV.PKGS where (LIB_ID= ?)";

            Pkgs() {
            }
        }
    }
}

