/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.List;
import org.eclipse.statet.internal.yaml.core.model.BasicYamlSourceElement;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceContainerElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.source.ast.Collection;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;

@NonNullByDefault
public abstract class ContainerSourceElement
extends BasicYamlSourceElement {
    ImList<YamlSourceElement> children = NO_CHILDREN;

    public ContainerSourceElement(YamlAstNode astNode) {
        super(astNode);
    }

    @Override
    public TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    public List<? extends SourceStructElement<?, ?>> getSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public abstract @Nullable ContainerSourceElement getModelParent();

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super YamlSourceElement> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    @Override
    public List<? extends YamlSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super YamlSourceElement> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    public static class CollectionContainer
    extends ContainerSourceElement {
        private final int type;
        private final ContainerSourceElement parent;
        private final YamlAstNode contentNode;

        public CollectionContainer(int type, ContainerSourceElement parent, YamlAstNode astNode, YamlAstNode contentNode) {
            super(astNode);
            this.type = type;
            this.parent = parent;
            this.contentNode = contentNode;
        }

        public final int getElementType() {
            return this.type;
        }

        public SourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public ContainerSourceElement getSourceParent() {
            return this.parent;
        }

        @Override
        public ContainerSourceElement getModelParent() {
            return this.parent;
        }

        @Override
        public <T> @Nullable T getAdapter(Class<T> adapterType) {
            if (adapterType == Collection.class) {
                return (T)((Object)this.contentNode);
            }
            return super.getAdapter(adapterType);
        }
    }

    public static class SourceContainer
    extends ContainerSourceElement
    implements SourceContainerElement<YamlSourceElement> {
        private final SourceUnit sourceUnit;
        private final SourceModelStamp stamp;

        public SourceContainer(SourceUnit sourceUnit, SourceModelStamp stamp, YamlAstNode astNode) {
            super(astNode);
            this.sourceUnit = sourceUnit;
            this.stamp = stamp;
            ElementName elementName = sourceUnit.getElementName();
            this.name = elementName instanceof YamlElementName ? (YamlElementName)elementName : YamlElementName.create(2, elementName.getSegmentName());
        }

        public int getElementType() {
            return 528;
        }

        @Override
        public String getId() {
            return this.sourceUnit.getId();
        }

        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public SourceModelStamp getStamp() {
            return this.stamp;
        }

        public boolean exists() {
            SourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("Yaml", 0, null);
            return modelInfo != null && modelInfo.getSourceElement() == this;
        }

        public boolean isReadOnly() {
            return this.sourceUnit.isReadOnly();
        }

        public @Nullable SourceStructElement<?, ?> getSourceParent() {
            return null;
        }

        @Override
        public @Nullable ContainerSourceElement getModelParent() {
            return null;
        }
    }
}

