/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.internal.yaml.core.model.YamlModelManagerImpl;
import org.eclipse.statet.yaml.core.BasicYamlCoreAccess;
import org.eclipse.statet.yaml.core.YamlCoreAccess;
import org.osgi.framework.BundleContext;

public class YamlCorePlugin
extends Plugin {
    private static YamlCorePlugin instance;
    private boolean started;
    private YamlModelManagerImpl yamlModelManager;
    private volatile YamlCoreAccess workbenchAccess;
    private volatile YamlCoreAccess defaultsAccess;

    public static YamlCorePlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        YamlCorePlugin plugin = YamlCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.yamlModelManager = new YamlModelManagerImpl();
        YamlCorePlugin yamlCorePlugin = this;
        synchronized (yamlCorePlugin) {
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            YamlCorePlugin yamlCorePlugin = this;
            synchronized (yamlCorePlugin) {
                this.started = false;
            }
            if (this.yamlModelManager != null) {
                this.yamlModelManager.dispose();
                this.yamlModelManager = null;
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
    }

    public YamlModelManagerImpl getYamlModelManager() {
        return this.yamlModelManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlCoreAccess getWorkbenchAccess() {
        YamlCoreAccess access = this.workbenchAccess;
        if (access == null) {
            YamlCorePlugin yamlCorePlugin = this;
            synchronized (yamlCorePlugin) {
                access = this.workbenchAccess;
                if (access == null) {
                    this.checkStarted();
                    access = this.workbenchAccess = new BasicYamlCoreAccess(EPreferences.getInstancePrefs());
                }
            }
        }
        return access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlCoreAccess getDefaultsAccess() {
        YamlCoreAccess access = this.defaultsAccess;
        if (access == null) {
            YamlCorePlugin yamlCorePlugin = this;
            synchronized (yamlCorePlugin) {
                access = this.defaultsAccess;
                if (access == null) {
                    this.checkStarted();
                    access = this.defaultsAccess = new BasicYamlCoreAccess(EPreferences.getDefaultPrefs());
                }
            }
        }
        return access;
    }
}

