/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.client;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class DaemonThreadFactory
implements ThreadFactory {
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;
    final String nameSuffix = "]";

    public DaemonThreadFactory(String name) {
        this.namePrefix = String.valueOf(name) + " [Thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement() + "]");
        t.setDaemon(true);
        t.setPriority(5);
        return t;
    }
}

