/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.REditor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.ElementNameComparator;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor2OutlinePage;
import org.eclipse.statet.r.core.refactoring.RRefactoring;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class ROutlinePage
extends SourceEditor2OutlinePage {
    private static final ViewerComparator ALPHA_COMPARATOR = new ElementNameComparator(RElementName.NAMEONLY_COMPARATOR);
    private final ContentFilter contentFilter = new ContentFilter();

    public ROutlinePage(REditor editor) {
        super((SourceEditor1)editor, "R", RRefactoring.getFactory(), "org.eclipse.statet.r.menus.ROutlineViewContextMenu");
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"ROutlineView");
    }

    protected LtkModelElementFilter<SourceStructElement<?, ?>> getContentFilter() {
        return this.contentFilter;
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.appendToGroup("view.sort", (IAction)new AlphaSortAction());
        toolBarManager.appendToGroup("view.filter", (IAction)new FilterCommonVariables());
        toolBarManager.appendToGroup("view.filter", (IAction)new FilterLocalDefinitions());
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        IPageSite site = this.getSite();
        super.contextMenuAboutToShow(menuManager);
        if (menuManager.find("stat.submit") == null) {
            menuManager.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        }
        menuManager.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR", null, null, null, null, null, "R", null, 8, null, false)));
        menuManager.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", null, null, null, null, null, "U", null, 8, null, false)));
        menuManager.add((IContributionItem)new Separator("more"));
    }

    private class AlphaSortAction
    extends SourceEditor1OutlinePage.ToggleAction {
        public AlphaSortAction() {
            super((SourceEditor1OutlinePage)ROutlinePage.this, "sort.alphabetically.enabled", false, 2);
            this.setText(SharedMessages.ToggleSortAction_name);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/sort.alpha"));
            this.setToolTipText(SharedMessages.ToggleSortAction_tooltip);
        }

        protected void configure(boolean on) {
            TreeViewer viewer = ROutlinePage.this.getViewer();
            if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                return;
            }
            viewer.setComparator((ViewerComparator)(on ? ALPHA_COMPARATOR : null));
        }
    }

    private class ContentFilter
    implements LtkModelElementFilter<SourceStructElement<?, ?>> {
        private boolean hideCommonVariables;
        private boolean hideLocalDefinitions;

        private ContentFilter() {
        }

        public boolean include(SourceStructElement<?, ?> element) {
            switch (element.getElementType()) {
                case 1585: {
                    return false;
                }
                case 1552: {
                    return !this.hideCommonVariables;
                }
                case 1553: {
                    return !this.hideCommonVariables && !this.hideLocalDefinitions;
                }
                case 1297: {
                    return !this.hideLocalDefinitions;
                }
            }
            return true;
        }
    }

    private class FilterCommonVariables
    extends SourceEditor1OutlinePage.ToggleAction {
        public FilterCommonVariables() {
            super((SourceEditor1OutlinePage)ROutlinePage.this, "filter.common_var.enabled", false, 2);
            this.setText(RUIMessages.Outline_HideGeneralVariables_name);
            this.setImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/ltool/filter.general"));
            this.setToolTipText(RUIMessages.Outline_HideGeneralVariables_name);
        }

        protected void configure(boolean on) {
            ROutlinePage.this.contentFilter.hideCommonVariables = on;
            TreeViewer viewer = ROutlinePage.this.getViewer();
            if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                return;
            }
            viewer.refresh(false);
        }
    }

    private class FilterLocalDefinitions
    extends SourceEditor1OutlinePage.ToggleAction {
        public FilterLocalDefinitions() {
            super((SourceEditor1OutlinePage)ROutlinePage.this, "filter.local.enabled", false, 2);
            this.setText(RUIMessages.Outline_HideLocalElements_name);
            this.setImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/ltool/filter.local"));
            this.setToolTipText(RUIMessages.Outline_HideLocalElements_name);
        }

        protected void configure(boolean on) {
            ROutlinePage.this.contentFilter.hideLocalDefinitions = on;
            TreeViewer viewer = ROutlinePage.this.getViewer();
            if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                return;
            }
            viewer.refresh(false);
        }
    }
}

