/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.core.util;

import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.tool.AbstractStatetRRunnable;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.ts.core.RToolService;

public class LoadReferenceRunnable
extends AbstractStatetRRunnable
implements SystemRunnable {
    private static final ImSet<String> LOAD_PKG_EXCLUDE_LIST = ImCollections.newSet((Object[])System.getProperty("org.eclipse.statet.r.console.namespaces.load.exclude", "").split(","));
    private final RReference reference;
    private final RElementName name;
    private final RProcess process;
    private final int stamp;
    private int loadOptions;
    private CombinedRElement resolvedElement;
    private boolean cancel;
    private int state;
    private Runnable finishRunnable;

    public static RProcess findRProcess(CombinedRElement element) {
        while (element != null) {
            if (element instanceof RProcessREnvironment) {
                return ((RProcessREnvironment)element).getSource();
            }
            element = element.getModelParent();
        }
        return null;
    }

    public static boolean isAccessAllowed(RElementName name, RWorkspace rWorkspace) {
        String pkgName;
        ImSet<String> excludePkgs = LOAD_PKG_EXCLUDE_LIST;
        if (excludePkgs.isEmpty()) {
            return true;
        }
        if (RElementName.isPackageFacetScopeType((int)name.getType())) {
            pkgName = name.getSegmentName();
        } else if (name.getScope() != null && RElementName.isPackageFacetScopeType((int)name.getScope().getType())) {
            pkgName = name.getScope().getSegmentName();
        } else {
            return true;
        }
        return !excludePkgs.contains("*") && !excludePkgs.contains(pkgName) || rWorkspace.isNamespaceLoaded(pkgName);
    }

    public LoadReferenceRunnable(RReference reference, RProcess tool, int stamp, String cause) {
        super("r/workspace/loadElements", NLS.bind((String)"Load elements of {0} (requested for {1})", (Object)((CombinedRElement)reference).getElementName().getDisplayName(), (Object)cause));
        this.reference = reference;
        this.name = null;
        this.process = tool;
        this.stamp = stamp;
    }

    public LoadReferenceRunnable(RElementName name, RProcess tool, int stamp, String cause) {
        super("r/workspace/loadElements", NLS.bind((String)"Load elements of {0} (requested for {1})", (Object)name.getDisplayName(), (Object)cause));
        this.reference = null;
        this.name = name;
        this.process = tool;
        this.stamp = stamp;
    }

    public final RProcess getTool() {
        return this.process;
    }

    public int getLoadOptions() {
        return this.loadOptions;
    }

    public void setLoadOptions(int options) {
        this.loadOptions = options;
    }

    public int getRequiredStamp() {
        return this.stamp;
    }

    public void cancel() {
        this.cancel = true;
    }

    public CombinedRElement getResolvedElement() {
        return this.resolvedElement;
    }

    public boolean isStarted() {
        return this.state == 320;
    }

    public boolean isFinished() {
        return (this.state & 0xFF0) == 336;
    }

    public void setFinishRunnable(Runnable runnable) {
        this.finishRunnable = runnable;
    }

    public boolean canRunIn(Tool tool) {
        return tool == this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changed(int event, Tool tool) {
        Runnable runnable = null;
        switch (event) {
            case 288: {
                if (this.cancel) {
                    LoadReferenceRunnable loadReferenceRunnable = this;
                    synchronized (loadReferenceRunnable) {
                        this.state = event;
                        ((Object)((Object)this)).notifyAll();
                        return true;
                    }
                }
                return false;
            }
            case 289: {
                return false;
            }
            case 290: 
            case 336: 
            case 340: 
            case 344: {
                LoadReferenceRunnable loadReferenceRunnable = this;
                synchronized (loadReferenceRunnable) {
                    this.state = event;
                    runnable = this.finishRunnable;
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
        }
        if (runnable != null) {
            runnable.run();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RToolService service, ProgressMonitor m) throws StatusException {
        int loadOptions;
        ICombinedRDataAdapter r = (ICombinedRDataAdapter)service;
        if (this.stamp != 0 && this.stamp != r.getChangeStamp()) {
            return;
        }
        LoadReferenceRunnable loadReferenceRunnable = this;
        synchronized (loadReferenceRunnable) {
            this.state = 320;
            loadOptions = this.loadOptions;
        }
        RWorkspace workspace = r.getWorkspaceData();
        this.resolvedElement = this.reference != null ? workspace.resolve(this.reference, 2, loadOptions, m) : workspace.resolve(this.name, 2, loadOptions, m);
    }
}

