/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeCoordinatesProvider;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;

public class FreezeSelectionStrategy
implements IFreezeCoordinatesProvider {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    public FreezeSelectionStrategy(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public PositionCoordinate getTopLeftPosition() {
        PositionCoordinate selectionAnchor = this.selectionLayer.getSelectionAnchor();
        if (selectionAnchor == null) {
            return null;
        }
        return new PositionCoordinate(this.freezeLayer, this.checkPosition(Orientation.HORIZONTAL, selectionAnchor.columnPosition), this.checkPosition(Orientation.VERTICAL, selectionAnchor.rowPosition));
    }

    private long checkPosition(Orientation orientation, long maxPosition) {
        long position;
        ViewportLayerDim viewportDim = this.viewportLayer.getDim(orientation);
        if (viewportDim.getSize() > 0L && (position = viewportDim.getOriginPosition()) < maxPosition) {
            return position;
        }
        return -1L;
    }

    @Override
    public PositionCoordinate getBottomRightPosition() {
        PositionCoordinate selectionAnchor = this.selectionLayer.getSelectionAnchor();
        if (selectionAnchor == null) {
            return null;
        }
        return new PositionCoordinate(this.freezeLayer, selectionAnchor.columnPosition - 1L, selectionAnchor.rowPosition - 1L);
    }
}

