/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data.core;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.data.DataProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.events.GeneralStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayerDim;
import org.eclipse.statet.ecommons.waltable.data.core.SizeConfig;
import org.eclipse.statet.ecommons.waltable.data.core.SizeConfigDim;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommandHandler;
import org.eclipse.statet.ecommons.waltable.refresh.core.StructuralRefreshCommandHandler;
import org.eclipse.statet.ecommons.waltable.refresh.core.VisualRefreshCommandHandler;
import org.eclipse.statet.ecommons.waltable.resize.core.DimResizeEvent;
import org.eclipse.statet.ecommons.waltable.resize.core.MultiColumnResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.resize.core.MultiRowResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.resize.core.PositionResizeCommandHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DataLayer
extends AbstractLayer<DataLayerDim<? extends DataLayer>>
implements Layer {
    public static final String PERSISTENCE_KEY_ROW_HEIGHT = ".rowHeight";
    public static final String PERSISTENCE_KEY_COLUMN_WIDTH = ".columnWidth";
    public static final int DEFAULT_COLUMN_WIDTH = 100;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    protected DataProvider dataProvider;
    private final long columnIdCat;
    private final SizeConfig columnWidthConfig;
    private final long rowIdCat;
    private final SizeConfig rowHeightConfig;

    public DataLayer(DataProvider dataProvider, long idCat) {
        this(dataProvider, idCat, 100, idCat, 20);
    }

    public DataLayer(DataProvider dataProvider, long columnIdCat, int defaultColumnWidth, long rowIdCat, int defaultRowHeight) {
        this(dataProvider, columnIdCat, new SizeConfig(defaultColumnWidth), rowIdCat, new SizeConfig(defaultRowHeight));
    }

    public DataLayer(DataProvider dataProvider, long columnIdCat, SizeConfig columnWidthConfig, long rowIdCat, SizeConfig rowHeightConfig) {
        this.columnIdCat = columnIdCat;
        this.columnWidthConfig = columnWidthConfig;
        this.rowIdCat = rowIdCat;
        this.rowHeightConfig = rowHeightConfig;
        this.init();
        this.registerCommandHandlers();
        this.setDataProvider(dataProvider);
    }

    @Override
    protected DataLayerDim<? extends DataLayer> createDim(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return new SizeConfigDim<DataLayer>(this, Orientation.HORIZONTAL, this.columnIdCat, this.columnWidthConfig){

                    @Override
                    public long getPositionCount() {
                        return DataLayer.this.dataProvider.getColumnCount();
                    }
                };
            }
            case VERTICAL: {
                return new SizeConfigDim<DataLayer>(this, Orientation.VERTICAL, this.rowIdCat, this.rowHeightConfig){

                    @Override
                    public long getPositionCount() {
                        return DataLayer.this.dataProvider.getRowCount();
                    }
                };
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        super.saveState(prefix, properties);
        this.columnWidthConfig.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_HEIGHT, properties);
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        super.loadState(prefix, properties);
        this.columnWidthConfig.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_HEIGHT, properties);
        this.fireLayerEvent(new GeneralStructuralChangeEvent(this));
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new PositionResizeCommandHandler(this));
        this.registerCommandHandler(new MultiColumnResizeCommandHandler(this));
        this.registerCommandHandler(new MultiRowResizeCommandHandler(this));
        this.registerCommandHandler(new UpdateDataCommandHandler(this));
        this.registerCommandHandler(new StructuralRefreshCommandHandler(this));
        this.registerCommandHandler(new VisualRefreshCommandHandler(this));
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected void setDataProvider(DataProvider dataProvider) {
        if (this.dataProvider instanceof Persistable) {
            this.unregisterPersistable((Persistable)((Object)this.dataProvider));
        }
        this.dataProvider = dataProvider;
        if (dataProvider instanceof Persistable) {
            this.registerPersistable((Persistable)((Object)dataProvider));
        }
    }

    public void setColumnWidthByPosition(long columnPosition, int width) {
        this.columnWidthConfig.setSize(columnPosition, width);
        this.fireLayerEvent(new DimResizeEvent((LayerDim)this.getDim(Orientation.HORIZONTAL), new LRange(columnPosition)));
    }

    public void setDefaultColumnWidth(int width) {
        this.columnWidthConfig.setDefaultSize(width);
    }

    public void setDefaultColumnWidthByPosition(long columnPosition, int width) {
        this.columnWidthConfig.setDefaultSize(columnPosition, width);
    }

    public void setColumnPositionResizable(long columnPosition, boolean resizable) {
        this.columnWidthConfig.setPositionResizable(columnPosition, resizable);
    }

    public void setColumnsResizableByDefault(boolean resizableByDefault) {
        this.columnWidthConfig.setResizableByDefault(resizableByDefault);
    }

    public void setRowHeightByPosition(long rowPosition, int height) {
        this.rowHeightConfig.setSize(rowPosition, height);
        this.fireLayerEvent(new DimResizeEvent((LayerDim)this.getDim(Orientation.VERTICAL), new LRange(rowPosition)));
    }

    public void setDefaultRowHeight(int height) {
        this.rowHeightConfig.setDefaultSize(height);
    }

    public void setDefaultRowHeightByPosition(long rowPosition, int height) {
        this.rowHeightConfig.setDefaultSize(rowPosition, height);
    }

    public void setRowPositionResizable(long rowPosition, boolean resizable) {
        this.rowHeightConfig.setPositionResizable(rowPosition, resizable);
    }

    public void setRowsResizableByDefault(boolean resizableByDefault) {
        this.rowHeightConfig.setResizableByDefault(resizableByDefault);
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        Object hDim = this.getDim(Orientation.HORIZONTAL);
        Object vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        return new DataLayerCell((LayerCellDim)new BasicLayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), (LayerCellDim)new BasicLayerCellDim(Orientation.VERTICAL, rowId, rowPosition));
    }

    @Override
    public @Nullable Layer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return null;
    }

    protected class DataLayerCell
    extends BasicLayerCell {
        public DataLayerCell(LayerCellDim horizontalDim, LayerCellDim verticalDim) {
            super(DataLayer.this, horizontalDim, verticalDim);
        }

        @Override
        public @Nullable Object getDataValue(int flags, @Nullable IProgressMonitor monitor) {
            return DataLayer.this.dataProvider.getDataValue(this.getColumnPosition(), this.getRowPosition(), flags, monitor);
        }
    }
}

