/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.command;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class AbstractDimPositionsCommand
implements LayerCommand {
    protected static final long NO_REF = -9223372036854775807L;
    private LayerDim layerDim;
    private long refPosition;
    private Collection<LRange> positions;

    protected AbstractDimPositionsCommand(LayerDim layerDim, long refPosition, Collection<LRange> positions) {
        this.layerDim = layerDim;
        this.refPosition = refPosition;
        this.positions = positions;
    }

    protected AbstractDimPositionsCommand(LayerDim layerDim, Collection<LRange> positions) {
        this(layerDim, -9223372036854775807L, positions);
    }

    protected AbstractDimPositionsCommand(AbstractDimPositionsCommand command) {
        this.layerDim = command.layerDim;
        this.refPosition = command.refPosition;
        this.positions = command.positions;
    }

    public final Orientation getOrientation() {
        return this.layerDim.getOrientation();
    }

    public final LayerDim getDim() {
        return this.layerDim;
    }

    public long getRefPosition() {
        return this.refPosition;
    }

    public Collection<LRange> getPositions() {
        return this.positions;
    }

    @Override
    public boolean convertToTargetLayer(Layer targetLayer) {
        LayerDim targetLayerDim = targetLayer.getDim(this.getOrientation());
        if (this.layerDim == targetLayerDim) {
            return true;
        }
        return this.convertToTargetLayer(this.layerDim, this.refPosition, targetLayerDim);
    }

    protected boolean convertToTargetLayer(LayerDim dim, long refPosition, LayerDim targetDim) {
        long targetRefPosition;
        LRangeList targetPositions = new LRangeList();
        if (refPosition == -9223372036854775807L) {
            targetRefPosition = -9223372036854775807L;
            for (LRange lRange : this.positions) {
                long position = lRange.start;
                while (position < lRange.end) {
                    long targetPosition = LayerUtils.convertPosition(dim, position, position, targetDim);
                    if (targetPosition != Long.MIN_VALUE) {
                        targetPositions.values().add(targetPosition);
                    }
                    ++position;
                }
            }
        } else if (refPosition != Long.MIN_VALUE) {
            targetRefPosition = LayerUtils.convertPosition(dim, refPosition, refPosition, targetDim);
            if (targetRefPosition == Long.MIN_VALUE) {
                return false;
            }
            for (LRange lRange : this.positions) {
                long position = lRange.start;
                while (position < lRange.end) {
                    long targetPosition = LayerUtils.convertPosition(dim, refPosition, position, targetDim);
                    if (targetPosition != Long.MIN_VALUE) {
                        targetPositions.values().add(targetPosition);
                    }
                    ++position;
                }
            }
        } else {
            targetRefPosition = Long.MIN_VALUE;
        }
        if (targetPositions.isEmpty()) {
            return false;
        }
        this.layerDim = targetDim;
        this.refPosition = targetRefPosition;
        this.positions = targetPositions;
        return true;
    }
}

