/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.internal.docmlet.tex.ui.TexUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.text.templates.ContextTypeRegistry;

@NonNullByDefault
public class LtxEditorTemplateCompletionComputer
extends TemplateCompletionComputer {
    public LtxEditorTemplateCompletionComputer() {
        super((TemplateStore)TexUIPlugin.getInstance().getLtxEditorTemplateStore(), (ContextTypeRegistry)TexUIPlugin.getInstance().getLtxEditorTemplateContextTypeRegistry());
    }

    protected String extractPrefix(AssistInvocationContext context) {
        try {
            IDocument document = context.getSourceViewer().getDocument();
            int end = context.getInvocationOffset();
            int start = Math.max(end - 50, 0);
            String text = document.get(start, end - start);
            for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '_') {
                    continue;
                }
                if (c == '\\') {
                    return text.substring(i);
                }
                return text.substring(i + 1);
            }
            return "";
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    protected @Nullable TemplateContextType getContextType(AssistInvocationContext context, TextRegion region) {
        try {
            SourceEditor editor = context.getEditor();
            AbstractDocument document = (AbstractDocument)context.getSourceViewer().getDocument();
            ITypedRegion partition = document.getPartition(editor.getDocumentContentInfo().getPartitioning(), region.getStartOffset(), true);
            if (partition.getType() == "Ltx.Math") {
                return this.getTypeRegistry().getContextType("org.eclipse.statet.docmlet.templates.LtxEditorMathContextType");
            }
            return this.getTypeRegistry().getContextType("org.eclipse.statet.docmlet.templates.LtxEditorDefaultContextType");
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            return null;
        }
    }
}

