/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.refactoring;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.docmlet.tex.core.ast.Environment;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAsts;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;

public class LtxRefactoringAdapter
extends RefactoringAdapter {
    public LtxRefactoringAdapter() {
        super("Ltx");
    }

    public String getPluginIdentifier() {
        return "org.eclipse.statet.docmlet.tex.core";
    }

    public LtxHeuristicTokenScanner getScanner(SourceUnit su) {
        return LtxHeuristicTokenScanner.create(su.getDocumentContentInfo());
    }

    public boolean canInsert(ElementSet elements, SourceElement to, RefactoringDestination.Position pos) {
        if (super.canInsert(elements, to, pos)) {
            if ((to.getElementType() & 0xFF0) == 1040) {
                for (LtkModelElement element : elements.getModelElements()) {
                    if ((element.getElementType() & 0xFF0) != 1056) continue;
                    return false;
                }
            }
            return (to.getElementType() & 0xF00) != 2048 || pos != RefactoringDestination.Position.INTO;
        }
        return false;
    }

    public boolean isCommentContent(ITypedRegion partition) {
        return partition != null && (partition.getType() == "Ltx.Comment" || partition.getType() == "Ltx.MathComment");
    }

    protected int getInsertionOffset(AbstractDocument document, SourceElement element, RefactoringDestination.Position pos, BasicHeuristicTokenScanner scanner) throws BadLocationException, BadPartitioningException {
        Environment environment;
        TexAstNode astNode;
        if ((element.getElementType() & 0xFF0) == 528 && pos == RefactoringDestination.Position.INTO && (astNode = (TexAstNode)((Object)element.getAdapter(TexAstNode.class))) != null && (environment = TexAsts.getDocumentNode(astNode)) != null && environment.getEndNode() != null) {
            return environment.getEndNode().getStartOffset();
        }
        return super.getInsertionOffset(document, element, pos, scanner);
    }
}

