/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.update;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.statet.internal.rhelp.server.update.REnvIndexController;
import org.eclipse.statet.internal.rhelp.server.update.REnvServiController;
import org.eclipse.statet.internal.rhelp.server.update.RLibPathsMonitor;
import org.eclipse.statet.internal.rhelp.server.update.RPkgManagerImpl;
import org.eclipse.statet.internal.rhelp.server.update.ServerREnvIndexUpdater;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.servi.RServi;
import org.eclipse.statet.rj.services.RService;

/*
 * Exception performing whole class analysis ignored.
 */
@NonNullByDefault
public class REnvIndexer
implements Runnable {
    public static final byte PERIODIC = 1;
    public static final byte LIB_PATHS_MONITOR = 2;
    public static final byte EXPLICITE = 3;
    private static final byte STOPPED = -1;
    private final REnvIndexController controller;
    private final REnv rEnv;
    private final String logPrefix;
    private byte isScheduled = (byte)-1;
    private int isRequested;
    private @Nullable ScheduledFuture<?> scheduled;
    private boolean isRunning;
    private final ProgressMonitor progress;
    private final RLibPathsMonitor rLibPathsMonitor;
    private final REnvServiController rServi;

    private static String getTriggerString(byte type) {
        switch (type) {
            case 1: {
                return "PERIODIC";
            }
            case 2: {
                return "LIB_PATHS_MONITOR";
            }
            case 3: {
                return "EXPLICITE";
            }
        }
        return Integer.toString(type);
    }

    public REnvIndexer(REnvIndexController controller, REnv rEnv) {
        this.controller = (REnvIndexController)ObjectUtils.nonNullAssert((Object)controller);
        this.rEnv = (REnv)ObjectUtils.nonNullAssert((Object)rEnv);
        this.logPrefix = String.format("REnv '%1$s': ", this.rEnv.getId());
        this.progress = new NullProgressMonitor();
        this.rLibPathsMonitor = new RLibPathsMonitor(this);
        this.rServi = new REnvServiController(this.rEnv);
    }

    public REnv getREnv() {
        return this.rEnv;
    }

    REnvIndexController getController() {
        return this.controller;
    }

    String getLogPrefix() {
        return this.logPrefix;
    }

    public synchronized void start() {
        if (this.isScheduled != -1) {
            return;
        }
        this.isScheduled = 0;
        this.schedule((byte)3);
    }

    public synchronized void stop() {
        if (this.isScheduled == -1) {
            return;
        }
        this.isScheduled = 0;
        this.rLibPathsMonitor.stop();
        ScheduledFuture scheduled = this.scheduled;
        if (scheduled != null) {
            this.scheduled = null;
            scheduled.cancel(false);
        }
    }

    public synchronized void schedule(byte type) {
        int delay;
        if (this.isScheduled < 0) {
            return;
        }
        if (this.isScheduled > type) {
            if (this.scheduled != null || this.isRunning) {
                return;
            }
            if (this.scheduled == null) {
                type = this.isScheduled;
                this.isScheduled = 0;
            }
        }
        if ((delay = this.getScheduleDelay(type)) < 0) {
            return;
        }
        ScheduledFuture scheduled = this.scheduled;
        if (scheduled != null) {
            this.scheduled = null;
            scheduled.cancel(false);
        }
        if (!this.isRunning) {
            this.scheduled = this.controller.schedule(this, delay);
        }
        this.isScheduled = type;
    }

    private int getScheduleDelay(byte type) {
        switch (type) {
            case 3: {
                return 100;
            }
            case 2: {
                return this.controller.getMonitorDelay();
            }
            case 1: {
                return this.controller.getPeriodicDelay();
            }
        }
        return -1;
    }

    public synchronized void cancel() {
        this.isScheduled = 0;
        ScheduledFuture scheduled = this.scheduled;
        if (scheduled != null) {
            this.scheduled = null;
            scheduled.cancel(false);
        }
        if (this.isRunning) {
            this.progress.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RServi r;
        byte trigger;
        REnvIndexer rEnvIndexer = this;
        synchronized (rEnvIndexer) {
            trigger = this.isScheduled;
            if (trigger <= 0) {
                return;
            }
            this.isScheduled = 0;
            this.isRunning = true;
            this.progress.setCanceled(false);
        }
        try {
            CommonsRuntime.log((Status)new InfoStatus("org.eclipse.statet.rhelp.server", String.format("%1$sR environment index update started (%2$s).", this.logPrefix, REnvIndexer.getTriggerString((byte)trigger))));
            this.rServi.configure();
            this.rServi.startR(this.progress);
            r = this.rServi.getRServi("R environment index");
            try {
                this.run((RService)r, this.progress);
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (Throwable e) {
            CommonsRuntime.log((Status)Status.newStatus((int)(e instanceof StatusException ? (int)((StatusException)e).getStatus().getSeverity() : 4), (String)"org.eclipse.statet.rhelp.server", (String)String.format("%1$sR environment index did not complete normally.", this.logPrefix), (Throwable)e));
        }
        finally {
            this.rServi.stopR();
            r = this;
            synchronized (r) {
                this.isRunning = false;
                this.schedule((byte)1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(RService r, ProgressMonitor m) throws StatusException {
        int request;
        REnvHelpConfiguration rEnvHelpConfig;
        RPkgManagerImpl rPkgManager = new RPkgManagerImpl(this.rEnv);
        rPkgManager.check(0, r, m);
        if (this.controller.getMonitorDelay() >= 0) {
            RPkgManagerDataset dataset = (RPkgManagerDataset)ObjectUtils.nonNullAssert((Object)rPkgManager.getDataset());
            this.rLibPathsMonitor.check(dataset.getRLibPaths());
        }
        if ((rEnvHelpConfig = (REnvHelpConfiguration)this.rEnv.get(REnvHelpConfiguration.class)) == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "R help configuration is missing."));
        }
        ServerREnvIndexUpdater updater = new ServerREnvIndexUpdater(rEnvHelpConfig, this.controller.getRHelpManager(), (RPkgManager)rPkgManager, (Executor)this.controller.getHelperExecutorService());
        REnvIndexer rEnvIndexer = this;
        synchronized (rEnvIndexer) {
            request = this.isRequested;
            this.isRequested = 0;
        }
        Status status = updater.update(r, request != 0, null, m);
        CommonsRuntime.log((Status)Status.newStatus((int)status.getSeverity(), (String)"org.eclipse.statet.rhelp.server", (int)status.getCode(), (String)(this.logPrefix + status.getMessage()), (Throwable)status.getException()));
    }
}

